/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- 
 * $Id: Member.java,v 1.2 2000/09/09 19:51:48 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 -- 2000 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel.reflect;

/**
 * Represents a member of a class, which is field or method.
 */
public interface Member extends java.lang.reflect.Member {
  
  /**
   * Returns modifiers and more.
   * <P>This method returns modifiers of the method in the less significant
   * half of the returned int, and the type of member in the other part.
   * The members are encoded according to the following scheme.
   * <PRE>
   * 1 - field
   * 2 - method
   * 3 - constructor (<init>)
   * </PRE>
   * @return modifiers for the method.
   */
  public int getModifiers();

  /**
   * Used to get the type of this member.
   * <P>For fields it is the field type, for methods it is the method
   * return value.
   * <P>Primitive types are encoded as <TT>TYPE</TT> fields of 
   * corresponding reflection objects.
   * @return the type of this member.
   */
  public Class getType();

  /**
   * Returns an integer identifier of this member type.
   * <P>For performance and indexing reasons JEL encodes all Java types
   * by integers. The encoding is defined in <TT>gnu.jel.TypesStack</TT>
   * class. This method returns an integer encoding of this member's type.
   * @return the type of this member encoded as an <TT>int</TT>.
   */
  public int getTypeID();

  /**
   * Used to get types and number of parameters needed to evaluate this member.
   * <P>Is there are no parameters (like for fields) it returns an array
   * of length zero.
   * @return the array of parameters of this member.
   */
  public Class[] getParameterTypes();

  /**
   * Evaluates the member.
   * <P>Looks up the value of the field or calls the method.
   * <P>Not all members can be evaluated, for example non static final 
   * local fields can not since they exist only in compiler's memory.
   * @param obj this pointer of corresponding object.
   * @param params array of parameters wrapped in reflection objects.
   * @return the result wrapped in a reflection object.
   */
  public Object eval(Object obj,Object[] params) throws Exception;

  /**
   * Generates the code for invocation of this member.
   * <P>For field/variable invoke means to get value. No type checks are
   * performed.
   * @param cf classfile to append instructions to.
   */
  public void code(gnu.jel.ClassFile cf);
};

