/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.debug.Tester;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Class[] staticLib;
    private Class[] dynamicLib;
    private Hashtable names;
    private Hashtable dynIDs;
    private Hashtable stateless;

    public Library(Class[] classArray, Class[] classArray2) {
        this.staticLib = classArray;
        this.dynamicLib = classArray2;
        this.rehash();
    }

    private void rehash() {
        this.names = new Hashtable();
        this.dynIDs = new Hashtable();
        this.stateless = new Hashtable();
        if (this.staticLib != null) {
            this.rehash(this.staticLib, true);
        }
        if (this.dynamicLib != null) {
            this.rehash(this.dynamicLib, false);
        }
    }

    private void rehash(Class[] classArray, boolean bl) {
        int n = 0;
        while (n < classArray.length) {
            Object object;
            Integer n2 = new Integer(n);
            Method[] methodArray = classArray[n].getMethods();
            int n3 = 0;
            while (n3 < methodArray.length) {
                if (Modifier.isStatic(methodArray[n3].getModifiers())) {
                    if (bl && this.rehash(((Method)(object = methodArray[n3])).getName(), ExpressionImage.getSignature((Method)object), object)) {
                        this.stateless.put(methodArray[n3], Boolean.TRUE);
                    }
                } else if (!bl && this.rehash(((Method)(object = methodArray[n3])).getName(), ExpressionImage.getSignature((Method)object), object)) {
                    this.dynIDs.put(methodArray[n3], n2);
                }
                ++n3;
            }
            object = classArray[n].getFields();
            int n4 = 0;
            while (n4 < ((Field[])object).length) {
                if (Modifier.isStatic(object[n4].getModifiers())) {
                    if (bl && this.rehash((Field)object[n4])) {
                        this.stateless.put(object[n4], Boolean.TRUE);
                    }
                } else if (!bl && this.rehash((Field)object[n4])) {
                    this.dynIDs.put(object[n4], n2);
                }
                ++n4;
            }
            ++n;
        }
    }

    private boolean rehash(Method method) {
        return this.rehash(method.getName(), ExpressionImage.getSignature(method), method);
    }

    private boolean rehash(Field field) {
        return this.rehash(field.getName(), "()" + ExpressionImage.getSignature(field.getType()), field);
    }

    private boolean rehash(String string, String string2, Object object) {
        Hashtable hashtable = (Hashtable)this.names.get(string);
        if (hashtable == null) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put(string2, object);
            this.names.put(string, hashtable2);
            return true;
        }
        Object v = hashtable.get(string2);
        if (v == null) {
            hashtable.put(string2, object);
            return true;
        }
        return false;
    }

    public void markStateDependent(String string, Class[] classArray) throws NoSuchMethodException {
        Object object = this.getMethod(string, classArray);
        Object v = this.stateless.remove(object);
    }

    public boolean isStateless(Object object) {
        return this.stateless.containsKey(object);
    }

    Object getMethod(String string, Class[] classArray) throws NoSuchMethodException {
        Object object;
        Object object2;
        Hashtable hashtable = (Hashtable)this.names.get(string);
        if (hashtable == null) {
            throw new NoSuchMethodException("The name \"" + string + "\" is not defined.");
        }
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = this.getParameterTypes(object2);
            boolean bl = false;
            if (classArray != null) {
                if (((Class[])object).length == classArray.length) {
                    bl = true;
                    int n = 0;
                    while (n < ((Class[])object).length && bl) {
                        bl = ExpressionImage.canConvertByWidening(classArray[n], object[n]);
                        ++n;
                    }
                }
            } else {
                boolean bl2 = bl = ((Class[])object).length == 0;
            }
            if (!bl) continue;
            vector.addElement(object2);
        }
        if (vector.size() == 0) {
            throw new NoSuchMethodException("Function \"" + string + "\" exists," + " but parameters " + this.describe(string, classArray) + " can not be accepted by it.");
        }
        if (vector.size() == 1) {
            return vector.firstElement();
        }
        object2 = vector.elements();
        object = object2.nextElement();
        Class[] classArray2 = this.getParameterTypes(object);
        while (object2.hasMoreElements()) {
            Object e = object2.nextElement();
            Class[] classArray3 = this.getParameterTypes(e);
            boolean bl = true;
            boolean bl3 = true;
            int n = 0;
            while (n < classArray3.length) {
                bl = bl && ExpressionImage.canConvertByWidening(classArray3[n], classArray2[n]);
                bl3 = bl3 && ExpressionImage.canConvertByWidening(classArray2[n], classArray3[n]);
                ++n;
            }
            if (bl && !bl3) {
                object = e;
                classArray2 = classArray3;
            }
            if (bl ^ bl3) continue;
            throw new NoSuchMethodException("Ambiguity detected between \"" + this.describe(string, classArray2) + "\" and \"" + this.describe(string, classArray3) + "\" on invocation \"" + this.describe(string, classArray) + "\" .");
        }
        return object;
    }

    private Class[] getParameterTypes(Object object) {
        Class[] classArray = null;
        if (object instanceof Field) {
            classArray = new Class[]{};
        } else if (object instanceof Method) {
            classArray = ((Method)object).getParameterTypes();
        }
        return classArray;
    }

    private String describe(String string, Class[] classArray) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('(');
        if (classArray != null) {
            int n = 0;
            while (n < classArray.length) {
                if (n != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(classArray[n].toString());
                ++n;
            }
        }
        stringBuffer.append(')');
        string2 = stringBuffer.toString();
        return string2;
    }

    int getDynamicMethodClassID(Object object) {
        Integer n = (Integer)this.dynIDs.get(object);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Tester tester = new Tester(System.out);
        Library.test(tester);
        tester.summarize();
    }

    public static void test(Tester tester) {
        Class[] classArray;
        Object object;
        Class[] classArray2;
        Library library = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        tester.startTest("Creating the library of java.lang.Math");
        try {
            classArray2 = new Class[]{clazz};
            object = new Library(classArray2, null);
            library = object;
            tester.testOK();
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(double)");
        try {
            classArray2 = new Class[]{Double.TYPE};
            object = (Method)library.getMethod("round", classArray2);
            if (object != null && ((Method)object).equals(clazz.getMethod("round", classArray2))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(float)");
        try {
            classArray2 = new Class[]{Float.TYPE};
            object = (Method)library.getMethod("round", classArray2);
            if (object != null && ((Method)object).equals(clazz.getMethod("round", classArray2))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation round(int) best is round(float)");
        try {
            classArray2 = new Class[]{Integer.TYPE};
            object = (Method)library.getMethod("round", classArray2);
            classArray = new Class[]{Float.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("round", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(int) best is abs(int)");
        try {
            classArray2 = new Class[]{Integer.TYPE};
            object = (Method)library.getMethod("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("abs", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(byte) best is abs(int)");
        try {
            classArray2 = new Class[]{Byte.TYPE};
            object = (Method)library.getMethod("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("abs", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation abs(char) best is abs(int)");
        try {
            classArray2 = new Class[]{Character.TYPE};
            object = (Method)library.getMethod("abs", classArray2);
            classArray = new Class[]{Integer.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("abs", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of invocation min(int,float) best is min(float,float)");
        try {
            classArray2 = new Class[]{Integer.TYPE, Float.TYPE};
            object = (Method)library.getMethod("min", classArray2);
            classArray = new Class[]{Float.TYPE, Float.TYPE};
            if (object != null && ((Method)object).equals(clazz.getMethod("min", classArray))) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Attempt of access to the field PI");
        try {
            classArray2 = new Class[]{};
            object = (Field)library.getMethod("PI", classArray2);
            if (object != null && ((Field)object).getName().equals("PI")) {
                tester.testOK();
            } else {
                tester.testFail();
            }
        }
        catch (Throwable throwable) {
            tester.testFail();
        }
        tester.startTest("Checking assignment of state dependence ");
        try {
            library.markStateDependent("random", null);
            if (!library.isStateless(library.getMethod("random", null))) {
                tester.testOK();
                return;
            }
            tester.testFail();
            return;
        }
        catch (Throwable throwable) {
            tester.testFail();
            return;
        }
    }
}

