/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_CIDF
    Description : IngriDF parser for C-Like GNU/EDMA IDFs
    Author      : David Martnez Oliveira
    Date        : March, 3rd, 2007
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/
#include <stdlib.h>
#include <string.h>
/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>
#include "cidf_parser.h"

/*
***************************************************
  Private Data Struct for class EDMA_CIDF
***************************************************
*/
 
/*
typedef struct {
 Put your field here
} DtEDMA_CIDF;
*/

/*
***************************************************
  Method Declaration for class EDMA_CIDF
***************************************************
*/
 
ESint32 EDMAPROC
EDMA_CIDFParseU32(OBJID obj, CLASSID idc)
{
  CIF_CLASS   *the_class;
  EChar     fn[2048];
  EChar     namespace[1024];
  EPChar     path;
  EChar     aux[1024], sig[1024], *asig;
  ESint32   i, j, repo_type;

  /* Get IDF directory*/
  path = edma_get_class_repo_dir (idc);
  edma_get_class_name (idc,aux);


  if ((repo_type = edma_get_class_repo_type (idc)) == 0)
    {
      edma_get_class_namespace (idc, namespace);
      sprintf (fn, "%s/share/edma/idf/%s/%s.cidf", path, namespace, aux);
    }
  else
    {
      char *rn = edma_get_class_repo_name (idc);
      edma_get_class_namespace (idc, namespace);
      sprintf (fn, "%s/%s/idf/%s/%s.cidf", 
	       path, rn, namespace, aux);
    }

  edma_printf_obj (obj, "Parsing Class %d:'%s': Repo: %d. Parser Object: %d", 
		   idc, aux, repo_type, obj);
  edma_printf_obj (obj, "Using IDF file : %s", fn);
  
  the_class = cidf_parse (fn);

  /* Create Class */
  edma_idf_set_def (idc, the_class->n_prop, the_class->n_met, 0);

  /* Set Properties */
  for (i = 0; i < the_class->n_prop; i++)
    {
      edma_idf_set_prop (idc, i, the_class->prop[i]->name, 
			 the_class->prop[i]->type, 
			 the_class->prop[i]->access, 
			 0, NULL); /* XXX: No support for arrays */
    }

  /* Set Methods */
  for (i = 0; i < the_class->n_met; i++)
    {
#if 1
      /* FIXME: Calculate Signature */
      memset (sig, 0, 1024);
      asig = sig;
      for (j = 0; j < the_class->met[i]->n_param; j++)
	{
	  EUint32  type_id;
	  EChar    type_sig[256];

	  type_id = edma_get_type_id (the_class->met[i]->param[j]->type);
	  memset (type_sig, 0, 256);
	  edma_get_type_sig (type_id, type_sig);
	  asig += sprintf (asig, "%s",  type_sig);
	}
      /* Add return type */
      {
	  EUint32  type_id;
	  EChar    type_sig[256];

	  type_id = edma_get_type_id (the_class->met[i]->rtype);
	  memset (type_sig, 0, 256);
	  edma_get_type_sig (type_id, type_sig);
	  asig += sprintf (asig, "r%s",  type_sig);
      }
      printf ("Generated signature is: '%s'\n", sig);
#endif


      if (!repo_type)
	edma_idf_set_met (idc, i, the_class->met[i]->name, sig, 
			  the_class->met[i]->flags[1],
			  the_class->met[i]->flags[0],
			  the_class->met[i]->flags[2]);
      else
	edma_idf_set_met (idc, i, the_class->met[i]->name, "", 
			  the_class->met[i]->flags[1],
			  the_class->met[i]->flags[0],

			  the_class->met[i]->flags[2]);

    }
#if 0
  /* Set superclass list */
  idSC = malloc (sizeof(EPChar) * the_class->n_sc);
  idDownAp = malloc (sizeof(EPChar) * the_class->n_sc);
  idUpAp = malloc (sizeof(EPChar) * the_class->n_sc);

  for (i = 0; i < the_class->n_sc; i++)
    {
      idSC[i] = the_class->sc[i]->name;
      idDownAp[i] = the_class->sc[i]->ap;
      idUpAp[i] = the_class->sc[i]->ap1;
    }

  edma_derive_class (the_class->name, idSC, idDownAp, idUpAp);



  free (idSC);
  free (idDownAp);
  free (idUpAp);
#endif

  for (i = 0; i < the_class->n_sc; i++)
    {
      edma_add_local_class_superclass_by_name (idc, the_class->sc[i]->name, 
					       the_class->sc[i]->ap, the_class->sc[i]->ap1);
    }


  edma_printf_obj (obj, "Registering class %d:%s:%s", 
		   idc, the_class->name, aux);


  if (repo_type)
    edma_idf_set_class_id1 (idc);
  else
    edma_idf_set_class_id (idc);

  //cidf_dump_class (the_class);
  cidf_free_data (the_class); 



  return 0;
}


ESint32
EDMA_CIDF_class_factory ()
{
  CLASSID    cid;

  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);
  
  edma_idf_set_class_name (cid, "EDMA_CIDF");
  
  edma_idf_set_class_namespace (cid, "");
  edma_idf_set_class_version (cid, 0, 0);
  
  
  /*UNKNOW ()*/
  /* Method registration */
  edma_add_local_class_method (cid, "Parse", "U32", 
			       (PPROC)EDMA_CIDFParseU32, 0, 0, 0);
  
  edma_idf_set_class_id (cid);
  
  return 0;
}


/********** END C IMPLEMENTATION SKELETON ******************/
