/* Copyright Per Bothner 1987. Read the file Q-INFO */
#ifndef TOKEN_H
#define TOKEN_H
struct DataToken
  {
    char kind;
    unsigned char options;
    struct DataToken *dependents; /* list of tokens which depend on this one */
	/* If ChainedToken, dependents points to the first IndirectToken
	 * in a list (linked by chain) that end up at this token.
	 * Otherwise, assuming dependents != NULL, it points to a list of
	 * GenOffsetTokens (linked by their next field). Each of these
	 * respresents the current (head) token, indexed by an offset.
	 * The last one has the LastToken option and points back to the head.
	 */
/*    short refCount; * number of other tokens that point to this one */
/* for regToAlias[reg]->refCount means reg is dirty and must be saved */
    union
      {
/*	Object object; */
/*	int reg; */
	struct DataToken *chain; /* if IndirectToken */
	struct
	  {
	    int reg;
	  } reg;
	struct
	  {
	    char *label;
	    long offset;
/*	    char flags; char kind; */
	  } constant;
	struct
	  {
	    int reg;
	    int offset;
	  } regoffset;
	struct
	  {
	    struct DataToken *next;
	    int offset;
	  } genoffset;
	struct
	  {
	    struct LocalVar *var;
	    int offset;
	  } temp;
      } u;
  };

/* data token kinds */
#define NullToken 0
#define RegToken 1
#define StackToken 2 /* Top of stack */
#define RegOffsetToken 3 /* *(reg+offset) */
#define TempToken 4
#define GenOffsetToken 5 /* *(token+offset) */
#define GenLabelToken 6 /* like ConstToken, but label is sequence number */
#define IndirectToken 7
/* the next two must be in order, and highest numbered */
#define ConstToken 9 /* optional label + offset */
#define SegOffsetToken(segment) (10+(segment))

/* data token options */
#define LiteralToken 1
#define EvalToken 2 /* if EvalCompile(cf) */
#define WordToken 4 /* operand is 2 bytes instead of default 4 bytes */
#define LastToken 8 /* next points to independent base token */
#define DirtyToken 16
#define HeapToken 32 /* temporatily heap-allocated root token */
#define ChainedToken 64
#define GlobalLabel 128

#define IgnoreResultToken NULL

extern struct DataToken _NullToken, _PushStackToken, _PopStackToken,
   ZeroToken[1];
#define PushStackToken &_PushStackToken
#define PopStackToken &_PopStackToken
#define FuncResultToken &_FuncResultToken
#endif TOKEN_H
