/* Copyright Per Bothner 1987. Read the file Q-INFO */
typedef struct
  {
#ifndef NEWENV
    long *statLink;
#endif
    HeapPrefix h;
  } FramePrefix;
struct Cframe
  {
    /* ... temporaries, incl. register save area ... */
    /* ... local variables ... */
    FramePrefix ex;
    /* The address of a frame is here */
    long *dynaLink;
    long *retAddr;
    long args[1];
  };
extern long *sp, *a1, *a6; /* register hack */
#define FrPrefix(fp) ((FramePrefix*)(fp) - 1)
#ifdef NEWENV
#define FrStatLink(fp) (toCframe(fp)->args[0])
#define SaveStatLink
#else
#define RgStatLink ((long*)a1)
#define FrStatLink(fp) FrPrefix(fp)->statLink
#define SaveStatLink asm(" movl a1,a6@(-8)")
#endif
#define toCframe(fp) ((struct Cframe*)((FramePrefix*)(fp)-1))
#define FrDynaLink(fp) (toCframe(fp)->dynaLink)
#define FrRetAddr(fp) (toCframe(fp)->retAddr)
#define FrArgs(fp) (toCframe(fp)->args)
#define FrFunc(fp) (FrRetAddr(fp)[-1]) /* only works for "long" calls */
#define FrDesc(fp) (ProcDesc)(((long*)FrFunc(fp))[-1])
#define curFrame (long*)a6

#define PDestrictor(name) asm(" .text"); asm(" .long name");
#define _PROC_ asm(" .text"); asm(" .long 0, 0");

/* short nFirst;
   unnamed arguments after the first nFirst, will be in the "var-num list".
   The remaining (non-multiple) arguments must all have defaultVal and name */

extern char *a7;
#define StackAlloc(n) ( a7 -= (n), a7 )
