/* Header file for the Freedom Remailer
   1995 jfleming@indiana.edu
   1997 hanne@squirrel.owl.de */

#ifndef FREEDOM_H
#define FREEDOM_H

#define DISCLAIMER \
"Comments: Please report problems with this automated remailing service\n" \
"\tto <%s>. The message sender's identity\n" \
"\tis unknown, unlogged, and not replyable.\n", COMPLAINTS

#define SYSLOG_FACILITY	LOG_USER

#ifndef PASS_PHRASE
#define PASS_PHRASE	"none"
#endif /* !PASS_PHRASE */

#ifndef REMAILER_DIR
#define REMAILER_DIR	"/home/remailer/freedom"
#endif /* !REMAILER_DIR */

#define REMAILER_BIN	"remailer"
#define MIX_MAIL	"mixmaster -Q"
#define MIX_NEWS	"mixmaster -Q post:"

/* updatestats() argument values */
enum stats_flag {
  STATS_MESSAGE,
  STATS_PGP,
  STATS_LATENT,
  STATS_WWW,
  STATS_POST,
  STATS_HELP,
  STATS_KEY,
  STATS_STAT
};

/* scan_message() return values */
enum message_type {
  NON_ANON,
  NULL_MESSAGE,
  PGP_MESSAGE,
  ANON_MESSAGE,
  ANON_POST,
  STATS_REQ,
  HELP_REQ,
  KEY_REQ,
  CUTMARKS,
  ENCRYPT_SUB,
  ENCRYPT_KEY,
  LATENT_TIME,
  URL_REQUEST,
  HTML_REQUEST
};

extern int USE_SYSLOG;
extern int USE_STATS;
extern int USE_MIX;
extern int ALLOW_PGP;
extern int ALLOW_POST;
extern int ALLOW_WWW;
extern int ALLOW_LTIME;
extern int SIZE_LIMIT;
extern char remailer_dir[];
extern char cur_dir[];
extern char MIX_DIR[];
extern char QUEUE_DIR[];
extern char PGP_DIR[];
extern char MAIL_SPOOL[];
extern char SENDMAIL[];
extern char INEWS[];
extern char PGP[];
extern char LYNX[];
extern char HELP_FILE[];
extern char KEY_FILE[];
extern char STATS_FILE[];
extern char SOURCE_BLOCK[];
extern char DEST_BLOCK[];
extern char SUBJ_BLOCK[];
extern char GROUP_BLOCK[];
extern char URL_BLOCK[];
extern char HDRFILTER[];
extern char REMAILER_NAME[];
extern char ANON_NAME[];
extern char ORGANIZATION[];
extern char MAIL2NEWS[];
extern char REMAILER_ADDR[];
extern char ANON_ADDR[];
extern char COMPLAINTS[];

/* function prototypes */
int init_remailer(void);
enum message_type scan_message(const char *, char *, char *);
void remove_headers(const char *, const char *, const char *);
int rxmatch(const char *, const char *);
void chop(char *);
int strileft(const char *, const char *);
int strifind(const char *, const char *);
int strieq(const char *, const char *);
int blocked(const char *, const char *);
void cut(const char *, const char *, const char *, const char *, const int);
void mailfile(const char *, const char *);
const char *basename(const char *);
void runlatentqueue(void);
void queuelatent(const char *, const char *);
int parsetime(const char *, const int);
int pgpdecrypt(const char *, const char *);
int encrypt_key(const char *, const char *, const char *);
int geturl(const char *, const char *, const int);
int scan_subject(const char *);
void encrypt_sub(const char *, const char *);
void updatestats(enum stats_flag);
void mailstats(const char *);

#endif /* !FREEDOM_H */
