/****************************************************************************
  This file is part of the Freedom Remailer.  It is:
  Copyright (C) 1995  John B. Fleming (jfleming@indiana.edu)
  Changes are (C) 1997 Johannes Kroeger (hanne@squirrel.owl.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/file.h>
#include <sys/wait.h>
#include "config.h"

void runlatentqueue(void)
{
  DIR *queuedir;
  FILE *in, *p;
  struct dirent *dir_entry;
  struct tm *curtime;
  time_t now;
  char filename[BUFSIZ], queuefile[BUFSIZ], input[BUFSIZ];
  int ctime, stime, cday, sday, lockfd;

  now = time(NULL);
  curtime = localtime(&now);
  ctime = (curtime->tm_hour * 60) + curtime->tm_min;
  cday = curtime->tm_wday;
  lockfd = open(REMAILER_DIR "/lock", O_CREAT | O_WRONLY, 0660);

  queuedir = opendir(QUEUE_DIR);
  if (queuedir != NULL) {
    while ((dir_entry = readdir(queuedir)) != NULL) {
      strcpy(filename, dir_entry->d_name);
      if (filename[0] == 'm') {
	/* control file found - process it */
	sprintf(queuefile, "%s/%s", QUEUE_DIR, filename);
	in = fopen(queuefile, "r");
	if (in != NULL) {
	  fgets(input, sizeof(input), in);
	  sday = atoi(input);
	  fgets(input, sizeof(input), in);
	  stime = atoi(input);
	  fclose(in);
	} else {
	  sday = 0;
	  stime = 0;
	}

	if ((cday > sday) || ((cday == 0) && (sday == 6)) ||
	    ((cday == sday) && (ctime >= stime))) {
	  /* time to send the message */
	  filename[0] = 'q';
	  sprintf(queuefile, "%s/%s", QUEUE_DIR, filename);
	  sprintf(input, "%s/sending%s", REMAILER_DIR, genid());
	  rename(queuefile, input);
	  filename[0] = 'm';
	  sprintf(queuefile, "%s/%s", QUEUE_DIR, filename);
	  unlink(queuefile);
	  strcpy(queuefile, input);
	  sprintf(input, "%s/%s", REMAILER_DIR, REMAILER_BIN);

	  /* pipe queued message to another remailer process */
	  in = fopen(queuefile, "r");
	  if (in != NULL) {
	    flock(lockfd, LOCK_UN | LOCK_NB);
	    p = popen(input, "w");
	    while (fgets(input, sizeof(input), in)) {
	      fputs(input, p);
	    }
	    fclose(in);
	    pclose(p);
	  }
	  unlink(queuefile);
	}
      }
/*      dir_entry = readdir(queuedir); */
    }
    closedir(queuedir);
  }
}

void encrypt_key(const char *toencrypt, char *toappendto, const char *key)
{
  pid_t status;
  char tempfile[BUFSIZ], line[BUFSIZ], pathenv[BUFSIZ];
  FILE *in, *out;

  sprintf(tempfile, "%s.asc", toencrypt);
  sprintf(pathenv, "PGPPATH=%s", PGP_DIR);
  putenv(pathenv);

  /* call PGP to do encryption */
  if (fork() == 0) {
    execlp(PGP, PGP, "-cat", "+batchmode", "+armorlines=0", "+verbose=0",
	   "-z", key, "-o", tempfile, toencrypt, NULL);
  } else {
    wait(&status);
  }
  putenv("PGPPATH=");

  /* append encrypted text to end of message */
  in = fopen(tempfile, "r");
  if (in != NULL) {
    out = fopen(toappendto, "a");
    fputs("**\n", out);
    while (fgets(line, sizeof(line), in)) {
      fputs(line, out);
    }
    fclose(out);
    fclose(in);
  }
  unlink(tempfile);
  unlink(toencrypt);
}

void mailurl(const char *url, const char *to, const char *bodyfile,
	     char *urlfile, const int type)
{
  FILE *out, *in, *p;
  pid_t status;
  char sendmail[BUFSIZ], input[BUFSIZ];

  out = fopen(urlfile, "w");
  if (blocked(url, URL_BLOCK)) {
    if (DEBUG) {
      printf("Blocked URL: %s\nNot downloading.\n", url);
      fflush(stdout);
    }
    fprintf(out, "You are not allowed to download %s\nthrough the %s.\n", url, REMAILER_NAME);
    fclose(out);
  } else {
    if (type == URL_REQUEST) {
      if (fork() == 0) {
	dup2(fileno(out), 1);
	fclose(out);
	if (DEBUG) {
	  printf("Downloading page %s ...\n", url);
	  fflush(stdout);
	}
#ifdef CERN
	execlp(WWW_BROWSE, WWW_BROWSE, "-n", url, NULL);
#endif /* CERN */
#ifdef LYNX
	execlp(WWW_BROWSE, WWW_BROWSE, "-dump", url, NULL);
#endif /* LYNX */
	if (DEBUG) {
	  printf("Download finished.\n");
	  fflush(stdout);
	}
      } else {
	wait(&status);
      }
    } else if (type == HTML_REQUEST) {
      if (fork() == 0) {
	dup2(fileno(out), 1);
	fclose(out);
	if (DEBUG) {
	  printf("Downloading HTML %s ...\n", url);
	  fflush(stdout);
	}
#ifdef CERN
	execlp(WWW_BROWSE, WWW_BROWSE, "-n", "-source", url, NULL);
#endif /* CERN */
#ifdef LYNX
	execlp(WWW_BROWSE, WWW_BROWSE, "-source", url, NULL);
#endif /* LYNX */
	if (DEBUG) {
	  printf("Download finished.\n");
	  fflush(stdout);
	}
      } else {
	wait(&status);
      }
    }
  }
  if (DEBUG) {
    printf("Mailing.\n");
    fflush(stdout);
  }
  sprintf(sendmail, "%s", SENDMAIL);
  p = (FILE *) popen(sendmail, "w");
  fprintf(p, "From: %s <%s>\n", ANON_NAME, ANON_ADDR);
  fprintf(p, DISCLAIMER);
  if (!scan_subject(bodyfile))
    fprintf(p, "Subject: None\n");

  in = fopen(bodyfile, "r");
  if (in != NULL) {
    while(fgets(input, sizeof(input), in)) {
      fputs(input, p);
    }
    fclose(in);
  }

  in = fopen(urlfile, "r");
  if (in != NULL) {
    fputs("\n", p);
    while(fgets(input, sizeof(input), in)) {
      fputs(input, p);
    }
    fclose(in);
  }
  pclose(p);
  unlink(urlfile);
}
