/****************************************************************************
  This file is part of the Freedom Remailer.  The genid() function
  is borrowed from Matt Ghio's remailer distribution.  Changes are:
  Copyright (C) 1997  Johannes Kroeger (hanne@squirrel.owl.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

#include <unistd.h>
#include <time.h>

/* Generate ASCII ID from process ID and time with shuffle */
char* genid(void) {
  unsigned long int id1, id2;
  int x = 0, idcount = 0;
  struct timeval tp;
  static char idbuf[17];

  id1 = getpid() | (idcount << 16);
  id2 = tp.tv_sec;
  idcount++;

  for(x = 32; x--; ) {
    id1 += 1234567890;
    id1 ^= 0xABCDEF12;
    id1 = (id1 << 1) | (id1 >> 31);
    id2 ^= id1;
    id2 += 0x12345678;
    id2 ^= 0x9ABCDEF0;
    id2 = (id2 << 31) | (id2 >> 1);
    id1 ^= id2;
  }
  for(x = 0; x < 8; x++) {
    idbuf[x] = 65 + (id1 & 15);
    id1 = id1 >> 4;
  }
  for(x = 8; x < 16; x++) {
    idbuf[x] = 65 + (id2 & 15);
    id2 = id2 >> 4;
  }
  idbuf[16] = 0;
  return idbuf;
}
