/* Configuration file for the Freedom Remailer
   1995 jfleming@indiana.edu
   1997 hanne@squirrel.owl.de */

#ifndef FREEDOM_CONFIG_H
#define FREEDOM_CONFIG_H

#include "freedom.h"

#define YES	1
#define NO	0

/* Features - define to NO to disable */
#define USE_STATS	YES
#define ALLOW_POST	YES
#define USE_PGP		YES
#define ALLOW_WWW	YES
#define DEBUG		YES

/* which WWW browser are you using (only if ALLOW_WWW is YES)
   don't forget to set the value of WWW_BROWSE below also
   ONLY DEFINE ONE! Comment out the one you do NOT want */
/* #define CERN */
#define LYNX

/* Regular Expression Blocking - Comment out to disable - READ DOCS */
#define REG_EXP_BLOCKING

/* Messages larger than SIZE_LIMIT bytes are deleted */
/* #define SIZE_LIMIT	2097152 */

/* Default latency for queuing messages if more than one remailer process
   is running at the same time.  Format: +h:mm(r) */
#define DEFAULT_LATENCY	"+0:00"

/* Paths, filenames and addresses */

#define REMAILER_DIR	"/home/remailer/freedom/freedom"
#define QUEUE_DIR	"/home/remailer/freedom/freedom/queue"
#define PGP_DIR		"/home/remailer/freedom/.pgp"
#define MAIL_SPOOL	"/var/spool/mail/freedom"

#define REMAILER_BIN	"remailer"
#define SENDMAIL	"/usr/sbin/sendmail -t"
#define PGP		"/usr/bin/pgp"
#define INEWS		"/usr/bin/inews"
#define WWW_BROWSE	"/usr/bin/lynx"

#define PASS_PHRASE	"foo-bar-mama"

#define HELP_FILE	"freedom-help"
#define PGP_KEY_FILE	"freedom-key"
#define STATS_FILE	"freedom-stats"

#define SOURCE_BLOCK	"blocked.source"
#define DEST_BLOCK	"blocked.destination"
#define SUBJ_BLOCK	"blocked.subject"
#define GROUP_BLOCK	"blocked.newsgroup"
#define URL_BLOCK	"blocked.url"
#define HDRFILTER	"headers.del"

#define REMAILER_NAME	"Freedom Remailer"
#define REMAILER_ADDR	"freedom@wherever"
#define ANON_NAME	"Anonymous"
#define ANON_ADDR	"nobody@wherever"
#define ORGANIZATION	"Anonymous Posting Service"
#define DISCLAIMER	"Comments: Please report problems with this automated remailing service\n\tto <remailer-admin@wherever>. The message sender's identity\n\tis unknown, unlogged, and not replyable.\n"

#define MAIL2NEWS	"mail2news@anon.lcs.mit.edu"

#endif
