/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>

#include <err.h>

#include <sl.h>

#include "msc.h"

static int milko_syscall = 210;

int
findmilkosyscall(void)
{
    char *mscenv;
    int oldsyscall = milko_syscall;

    mscenv = getenv("MILKO_SYSCALL");
    if (mscenv && sscanf(mscenv, "%d", &milko_syscall) != 1) {
	warnx("Invalid format of MILKO_SYSCALL: '%s'\n", mscenv);
	milko_syscall = oldsyscall;
    }

    return milko_syscall;
}

int
iversion(void)
{
    struct msc_cmd cmd;

    cmd.fd = -1;
    cmd.opcode = MSC_VERSION;
    return syscall(milko_syscall, &cmd);
}
    
int
iopen(int fd, ino_t ino, int flags)
{
    struct msc_cmd cmd;

    cmd.fd = fd;
    cmd.opcode = MSC_IOPEN;
    cmd.flags = flags;
    cmd.ino = ino;

    if (cmd.fd < 0)
	return EINVAL;

    return syscall(milko_syscall, &cmd);

    return 0;
}

int
istatpath(int fd, char *path, struct stat *sb)
{
    struct msc_cmd cmd;

    cmd.fd = fd;
    cmd.opcode = MSC_ISTATPATH;
    cmd.path = path;
    cmd.sb = sb;

    if (cmd.fd < 0)
	return EINVAL;

    return syscall(milko_syscall, &cmd);

    return 0;
}
