/* pggalgo.h - data structure definition of PggAlgo
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGALGO_H_19990618233713
#define PGG_INCLUDE_PGGALGO_H_19990618233713


#include <pgg.h>
#include <pggimpl.h>


_mktype(PggAlgo)
{
    unsigned long	magic;
    int			refcounter;
    PggAlgo_Cipher	cipher;
    PggAlgo_Digest	digest;
    PggAlgo_Compress	compress;
    PggAlgo_Packet	packet;
    PggAlgo_S2kMode	s2k_mode;
    PggAlgo_Cipher	s2k_cipher;
    PggAlgo_Digest	s2k_digest;
};


_mktypeptr(PggAlgo);


#define PggAlgoMAGIC 0xFF0F0999


#endif


