/*
 * Copyright (c) 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "milko_locl.h"
#include "security.h"
#include "rxkad_locl.h"
#include "acl.h"

RCSID("$Id: security.c,v 1.1 1998/10/14 00:59:00 map Exp $");

char acl_file[] = "/usr/arla/etc/superuserlist"; /* XXX */

/*
 * Return 0 if the user is not a superuser
 *        1 if the user is a superuser
 */

int
sec_is_superuser(struct rx_call *call)
{
    char aname[ANAME_SZ];
    char inst[INST_SZ];
    char realm[REALM_SZ];
    char fullname[MAX_K_NAME_SZ];

    if (sec_getname(call, aname, inst, realm))
	return 0;
    krb_unparse_name_long_r(aname, inst, realm, fullname);
    return acl_check(acl_file, fullname);
}

int
sec_add_superuser(char *user)
{
    return acl_add(acl_file, user);
}

int
sec_del_superuser(char *user)
{
    return acl_delete(acl_file, user);
}

/*
 * Get the parsed name of a connection.
 * name, instance and realm should be properly allocated
 * Returns zero on success
 */

int
sec_getname(struct rx_call *call, char *name, char *instance, char *realm)
{
    serv_con_data *cdat;

    if (call->conn->securityIndex == 2) {
	cdat = call->conn->securityData;
	strncpy(name, cdat->user->name, ANAME_SZ);
	strncpy(instance, cdat->user->instance, INST_SZ);
	strncpy(realm, cdat->user->realm, REALM_SZ);
	return 0;
    }
    return -1;
}
