#! /bin/sh
#
# apache	Start the apache HTTP server.
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=/usr/sbin/apache
NAME=apache
FLAGS="defaults 91"
PIDFILE=/var/run/$NAME.pid

trap "" 1
trap "" 15

test -f $DAEMON || exit 0

case "$1" in
  start)
    echo -n "Starting Apache webserver..."
    if start-stop-daemon --start --quiet --pidfile $PIDFILE \
	--exec $DAEMON
    then
	echo "done."
    else
	echo "failed."
    fi
    ;;

  stop)
    echo -n "Stopping Apache webserver..."
    start-stop-daemon --stop --quiet --oknodo --pidfile $PIDFILE --exec $DAEMON
    killall apache > /dev/null 2>&1
    echo "done."
    ;;

  reload)
    echo -n "Reloading Apache configuration files..."
    start-stop-daemon --stop --signal 1 --quiet --pidfile $PIDFILE \
	--exec $DAEMON
    echo "done."
    ;;

  reload-modules)
    echo -n "Stopping Apache webserver..."
    killall apache > /dev/null 2>&1
    killall apache > /dev/null 2>&1
    echo -n "sleeping..."
    sleep 4
    echo -n "starting again..."
    if start-stop-daemon --start --quiet --pidfile $PIDFILE \
	--exec $DAEMON
    then
	echo "done."
    else
	echo "failed."
    fi
    ;;

  *)
    echo "Usage: /etc/init.d/$NAME {start|stop|reload|reload-modules}"
    exit 1
    ;;
esac

exit 0

