#ifndef _xfs_h
#define _xfs_h

#include <xfs/xfs_common.h>
#include <xfs/xfs_node.h>
#include <linux/types.h>

/*
 * Filesystem struct.
 */
struct xfs {
    u_int status;		/* Inited, opened or mounted */
#define XFS_MOUNTED	0x1
#define XFS_DEVOPEN	0x2
#define XFS_ROOTINSTALLED 0x4
    struct super_block *sb;
    struct xfs_node *root;
    u_int nnodes;
    
    struct xfs_node *nodes;		/* replace with hash table */
    int fd;
};

#define VFS_TO_XFS(v)      ((struct xfs *) ((v)->u.generic_sbp))
#define XFS_TO_VFS(x)      ((x)->sb)

#define XFS_FROM_VNODE(vp) VFS_TO_XFS((vp)->i_sb)
#define XFS_FROM_XNODE(xp) XFS_FROM_VNODE(XNODE_TO_VNODE(xp))

extern struct xfs xfs[];

extern struct vnodeops xfs_vnodeops;

struct xfs_node *xfs_node_find (struct xfs *, struct xfs_handle *);
struct xfs_node *new_xfs_node (struct xfs *, struct xfs_msg_node *);
void free_xfs_node (struct xfs_node *);
void free_all_xfs_nodes (struct xfs *xfsp);

int xfs_has_pag(const struct xfs_node *xn, pag_t);

void xfs_invalid_xnode(struct xfs_node *xnode);
void xfs_attr2inode(const struct xfs_attr *attr, struct inode *inode);
#endif /* _xfs_h */
