dnl
dnl $Id: aclocal.m4,v 1.45 1998/12/28 17:20:06 assar Exp $
dnl

dnl
dnl General tests

define(upcase,`echo $1 | tr abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ`)dnl

dnl
dnl Look for function in any of the specified libraries
dnl

dnl AC_FIND_FUNC_NO_LIBS(func, libraries, includes, arguments)
AC_DEFUN(AC_FIND_FUNC_NO_LIBS, [

AC_MSG_CHECKING([for $1])
AC_CACHE_VAL(ac_cv_funclib_$1,
[
if eval "test \"\$ac_cv_func_$1\" != yes" ; then
	ac_save_LIBS="$LIBS"
	for ac_lib in "" $2; do
		if test -n "$ac_lib"; then 
			ac_lib="-l$ac_lib"
			LIBS="$ac_lib $ac_save_LIBS"
		fi
		AC_TRY_LINK([$3],[$1($4)],eval "if test -n \"$ac_lib\";then ac_cv_funclib_$1=$ac_lib; else ac_cv_funclib_$1=yes; fi";break)
	done
	eval "ac_cv_funclib_$1=\${ac_cv_funclib_$1-no}"
	LIBS="$ac_save_LIBS"
fi
])

eval "ac_res=\$ac_cv_funclib_$1"

# autoheader tricks *sigh*
: << END
@@@funcs="$funcs $1"@@@
@@@libs="$libs $2"@@@
END

# $1
eval "ac_tr_func=HAVE_[]upcase($1)"
eval "ac_tr_lib=HAVE_LIB[]upcase($ac_res | sed -e 's/-l//')"
eval "LIB_$1=$ac_res"

case "$ac_res" in
	yes)
	eval "ac_cv_func_$1=yes"
	eval "LIB_$1="
	AC_DEFINE_UNQUOTED($ac_tr_func)
	AC_MSG_RESULT([yes])
	;;
	no)
	eval "ac_cv_func_$1=no"
	eval "LIB_$1="
	AC_MSG_RESULT([no])
	;;
	*)
	eval "ac_cv_func_$1=yes"
	eval "ac_cv_lib_`echo "$ac_res" | sed 's/-l//'`=yes"
	AC_DEFINE_UNQUOTED($ac_tr_func)
	AC_DEFINE_UNQUOTED($ac_tr_lib)
	AC_MSG_RESULT([yes, in $ac_res])
	;;
esac
AC_SUBST(LIB_$1)
])


dnl test for ELF

AC_DEFUN(AC_ELF_OBJECT_FORMAT,[
AC_CACHE_CHECK([for ELF object format], ac_cv_sys_elf_object_format,[
ac_cv_sys_elf_object_format=no
echo 'int foo;' > conftest.$ac_ext
if AC_TRY_EVAL(ac_compile); then
	case `file conftest.o 2> /dev/null` in
	*ELF*)	ac_cv_sys_elf_object_format=yes ;;
	esac
fi
rm -f conftest*])])

dnl 
dnl Check for functions that are in the kernel
dnl

AC_DEFUN(AC_KERNEL,
[
dnl XXX XXX XXX *** this test sucks *** XXX XXX XXX
if test "$ac_kernel_ld" = ""; then
if test "$ac_cv_sys_elf_object_format" = yes; then
ac_kernel_ld='${LD-ld} -o conftest $LDFLAGS -R $KERNEL conftest.o -e _foo 1>&AC_FD_CC'
else
ac_kernel_ld='${LD-ld} -o conftest $LDFLAGS -A $KERNEL conftest.o -e _foo 1>&AC_FD_CC'
fi
fi
])

AC_DEFUN(AC_TRY_COMPILE_KERNEL,[
save_CFLAGS="$CFLAGS"
CFLAGS="$CFLAGS $test_KERNEL_CFLAGS"
AC_TRY_COMPILE([$1], [$2], [$3], [$4])
CFLAGS="$save_CFLAGS"
])



dnl AC_CHECK_KERNEL(name, cv, magic, [includes])
AC_DEFUN(AC_CHECK_KERNEL,
[AC_MSG_CHECKING([for $1 in kernel])
AC_CACHE_VAL($2,
[cat > conftest.$ac_ext <<EOF
dnl This sometimes fails to find confdefs.h, for some reason.
dnl [#]line __oline__ "[$]0"
[#]line __oline__ "configure"
#include "confdefs.h"
[$4]
int _foo() {
return foo();
}
int foo() {
[$3];
return 0; }
EOF
save_CFLAGS="$CFLAGS"
CFLAGS="$CFLAGS $test_KERNEL_CFLAGS"
if AC_TRY_EVAL(ac_compile) && AC_TRY_EVAL(ac_kernel_ld) && test -s conftest; then
  eval "$2=yes"
else
  eval "$2=no"
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
fi
CFLAGS="$save_CFLAGS"
rm -f conftest*])
changequote(, )dnl
eval "ac_tr_var=HAVE_KERNEL_`echo $1 | tr '[a-z]' '[A-Z]'`"
changequote([, ])dnl

define([foo], [[HAVE_KERNEL_]translit($1, [a-z], [A-Z])])
: << END
@@@syms="$syms foo"@@@
END
undefine([foo])

AC_MSG_RESULT([$]$2)
if eval "test \"\[$]$2\" = yes"; then
  AC_DEFINE_UNQUOTED($ac_tr_var)
fi
])

dnl AC_CHECK_KERNEL_FUNC(func, param, [includes])
AC_DEFUN(AC_CHECK_KERNEL_FUNC,
AC_CHECK_KERNEL($1, ac_cv_kernel_func_$1, [$1]([$2]), $4))

dnl AC_CHECK_KERNEL_VAR(var, type, [includes])
AC_DEFUN(AC_CHECK_KERNEL_VAR,
AC_CHECK_KERNEL($1, ac_cv_kernel_var_$1, [extern $2 $1; $2 foo = $1], $4))

dnl AC_CHECK_KERNEL_FUNCS(functions...)
AC_DEFUN(AC_CHECK_KERNEL_FUNCS,
[for ac_func in $1
do
AC_CHECK_KERNEL_FUNC($ac_func)
done
])

dnl
dnl Check for types
dnl

AC_DEFUN(AC_GROK_TYPE, [
AC_CACHE_VAL(ac_cv_type_$1, 
AC_TRY_COMPILE([
#include "confdefs.h"
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_BITYPES_H
#include <sys/bitypes.h>
#endif
#ifdef HAVE_BIND_BITYPES_H
#include <bind/bitypes.h>
#endif
#ifdef HAVE_NETINET_IN6_MACHTYPES_H
#include <netinet/in6_machtypes.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_KTYPES_H
#include <ktypes.h>
#endif
],
$i x;
,
eval ac_cv_type_$1=yes,
eval ac_cv_type_$1=no))])


AC_DEFUN(AC_GROK_TYPES, [
for i in $1; do
        AC_MSG_CHECKING(for $i)
        AC_GROK_TYPE($i)
        eval ac_res=\$ac_cv_type_$i
        if test "$ac_res" = yes; then
                type=HAVE_`echo $i | tr '[a-z]' '[A-Z]'`
                AC_DEFINE_UNQUOTED($type)
        fi
        AC_MSG_RESULT($ac_res)
done
])

dnl
dnl Check for types in the Linux kernel
dnl

AC_DEFUN(AC_GROK_LINUX_KERNEL_TYPE, [
AC_CACHE_VAL(ac_cv_linux_kernel_type_$1, 
AC_TRY_COMPILE([
#define __KERNEL__
#include <linux/types.h>
],
$1 x;
,
eval ac_cv_linux_kernel_type_$1=yes,
eval ac_cv_linux_kernel_type_$1=no))])

AC_DEFUN(AC_GROK_LINUX_KERNEL_TYPES, [
for i in $1; do
        AC_MSG_CHECKING(for $i in the linux kernel)
        AC_GROK_LINUX_KERNEL_TYPE($i)
        eval ac_res=\$ac_cv_linux_kernel_type_$i
        if test "$ac_res" = yes; then
                type=HAVE_LINUX_KERNEL_`echo $i | tr '[a-z]' '[A-Z]'`
                AC_DEFINE_UNQUOTED($type)
        fi
        AC_MSG_RESULT($ac_res)
done
])

dnl
dnl test for how to do ntohl
dnl

AC_DEFUN(AC_FUNC_NTOHL, [
AC_REQUIRE([AC_CANONICAL_TARGET])
AC_MSG_CHECKING(for efficient ntohl)
AC_CACHE_VAL(ac_cv_func_ntohl, [
case "$target_cpu" in
changequote(, )dnl
i[3-9]86) AC_TRY_RUN(
changequote([, ])dnl
[
#if defined(__GNUC__) && defined(i386)
unsigned long foo(unsigned long x)
{
  asm("bswap %0" : "=r" (x) : "0" (x));
  return x;
}
#endif

int main(void)
{
  return foo(0x12345678) != 0x78563412;
}
],
ac_cv_func_ntohl="bswap",
ac_cv_func_ntohl="ntohl",
ac_cv_func_ntohl="ntohl") ;;
alpha) ac_cv_func_ntohl="bswap32" ;;
*) ac_cv_func_ntohl="ntohl" ;;
esac
])
AC_MSG_RESULT($ac_cv_func_ntohl)
AC_DEFINE_UNQUOTED(EFF_NTOHL, $ac_cv_func_ntohl)
])

dnl
dnl Same as AC _REPLACE_FUNCS, just define HAVE_func if found in normal
dnl libraries 

AC_DEFUN(AC_BROKEN,
[for ac_func in $1
do
AC_CHECK_FUNC($ac_func, [
changequote(, )dnl
ac_tr_func=HAVE_`echo $ac_func | tr '[a-z]' '[A-Z]'`
changequote([, ])dnl
AC_DEFINE_UNQUOTED($ac_tr_func)],[LIBOBJS="$LIBOBJS ${ac_func}.o"])
# autoheader tricks *sigh*
: << END
@@@funcs="$funcs $1"@@@
END
done
AC_SUBST(LIBOBJS)dnl
])


dnl
dnl AC_FIND_FUNC(func, libraries, includes, arguments)
dnl

AC_DEFUN(AC_FIND_FUNC, [
AC_FIND_FUNC_NO_LIBS([$1], [$2], [$3], [$4])
if test -n "$LIB_$1"; then
	LIBS="$LIB_$1 $LIBS"
fi
])

dnl
dnl Mix between AC_FIND_FUNC and AC_BROKEN
dnl

AC_DEFUN(AC_FIND_IF_NOT_BROKEN,
[AC_NEED_PROTO([$3],[$1])
AC_FIND_FUNC([$1], [$2], [$3], [$4])
if eval "test \"$ac_cv_func_$1\" != yes"; then
LIBOBJS="$LIBOBJS $1.o"
fi
AC_SUBST(LIBOBJS)dnl
])

dnl
dnl Search for struct winsize
dnl

AC_DEFUN(AC_KRB_STRUCT_WINSIZE, [
AC_MSG_CHECKING(for struct winsize)
AC_CACHE_VAL(ac_cv_struct_winsize, [
ac_cv_struct_winsize=no
for i in sys/termios.h sys/ioctl.h; do
AC_EGREP_HEADER(
changequote(, )dnl
struct[ 	]*winsize,dnl
changequote([,])dnl
$i, ac_cv_struct_winsize=yes; break)dnl
done
])
if test "$ac_cv_struct_winsize" = "yes"; then
  AC_DEFINE(HAVE_STRUCT_WINSIZE, 1)dnl
fi
AC_MSG_RESULT($ac_cv_struct_winsize)
AC_EGREP_HEADER(ws_xpixel, termios.h, AC_DEFINE(HAVE_WS_XPIXEL))
AC_EGREP_HEADER(ws_ypixel, termios.h, AC_DEFINE(HAVE_WS_YPIXEL))
])

dnl
dnl Test for __FUNCTION__
dnl

AC_DEFUN(AC_C___FUNCTION__, [
AC_MSG_CHECKING(for __FUNCTION__)
AC_CACHE_VAL(ac_cv___function__, [
AC_TRY_RUN([
#include <string.h>

static char *foo()
{
  return __FUNCTION__;
}

int main()
{
  return strcmp(foo(), "foo") != 0;
}
],
ac_cv___function__=yes,
ac_cv___function__=no,
ac_cv___function__=no)])
if test "$ac_cv___function__" = "yes"; then
  AC_DEFINE(HAVE___FUNCTION__)
fi
AC_MSG_RESULT($ac_cv___function__)
])

dnl
dnl Test for __attribute__
dnl

AC_DEFUN(AC_C___ATTRIBUTE__, [
AC_MSG_CHECKING(for __attribute__)
AC_CACHE_VAL(ac_cv___attribute__, [
AC_TRY_COMPILE([
#include <stdlib.h>
],
[
static void foo(void) __attribute__ ((noreturn));

static void __attribute__ ((noreturn))
foo(void)
{
  exit(1);
}
],
ac_cv___attribute__=yes,
ac_cv___attribute__=no)])
if test "$ac_cv___attribute__" = "yes"; then
  AC_DEFINE(HAVE___ATTRIBUTE__)
fi
AC_MSG_RESULT($ac_cv___attribute__)
])

dnl
dnl stolen from bash
dnl

AC_DEFUN(BASH_CHECK_DEV_FD,
[AC_MSG_CHECKING(whether /dev/fd is available)
AC_CACHE_VAL(bash_cv_dev_fd,
[if test -d /dev/fd  && test -r /dev/fd/0; then
   bash_cv_dev_fd=standard
 elif test -d /proc/self/fd && test -r /proc/self/fd/0; then
   bash_cv_dev_fd=whacky
 else
   bash_cv_dev_fd=absent
 fi
])
AC_MSG_RESULT($bash_cv_dev_fd)
if test $bash_cv_dev_fd = "standard"; then
  AC_DEFINE(HAVE_DEV_FD)
  AC_DEFINE(DEV_FD_PREFIX, "/dev/fd/")
elif test $bash_cv_dev_fd = "whacky"; then
  AC_DEFINE(HAVE_DEV_FD)
  AC_DEFINE(DEV_FD_PREFIX, "/proc/self/fd/")
fi
])

dnl
dnl Check if we need the prototype for a function
dnl

dnl AC_NEED_PROTO(includes, function)

AC_DEFUN(AC_NEED_PROTO, [
AC_CACHE_CHECK([if $2 needs a prototype], ac_cv_func_$2_noproto,
AC_TRY_COMPILE([$1],
[struct foo { int foo; } xx;
extern int $2 (struct foo*);
$2(&xx);
],
eval "ac_cv_func_$2_noproto=yes",
eval "ac_cv_func_$2_noproto=no"))
define([foo], [NEED_]translit($2, [a-z], [A-Z])[_PROTO])
if test "$ac_cv_func_$2_noproto" = yes; then
	AC_DEFINE(foo)
fi
: << END
@@@syms="$syms foo"@@@
END
undefine([foo])
])

dnl
dnl Test if hstrerror wants const or not
dnl

dnl AC_HSTRERROR_CONST(includes, function)

AC_DEFUN(AC_HSTRERROR_CONST, [
AC_CACHE_CHECK([if hstrerror needs const], ac_cv_func_hstrerror_const,
AC_TRY_COMPILE([netdb.h],
[const char *hstrerror(int);],
eval "ac_cv_func_hstrerror_const=no",
eval "ac_cv_func_hstrerror_const=yes"))
define([foo], [NEED_HSTRERROR_CONST])
if test "$ac_cv_func_hstrerror_const" = yes; then
	AC_DEFINE(foo)
fi
: << END
@@@syms="$syms foo"@@@
END
undefine([foo])
])

#
# Test for kerberos include files
#

AC_DEFUN(AC_KRB_INC_WHERE1, [
saved_CPPFLAGS=$CPPFLAGS
CPPFLAGS="$saved_CPPFLAGS -I$1"
AC_TRY_COMPILE([#include <krb.h>],
[struct ktext foo;],
ac_cv_found_krb_inc=yes,
ac_cv_found_krb_inc=no)
if test "$ac_cv_found_krb_inc" = "no"; then
  CPPFLAGS="$saved_CPPFLAGS -I$1 -I$1/kerberosIV"
  AC_TRY_COMPILE([#include <krb.h>],
  [struct ktext foo;],
  [ac_cv_found_krb_inc=yes
   ac_cv_is_krb5=yes],
  ac_cv_found_krb_inc=no)
fi
CPPFLAGS=$saved_CPPFLAGS
])

AC_DEFUN(AC_KRB_INC_WHERE, [
   for i in $1; do
      AC_MSG_CHECKING(for kerberos headers in $i)
      AC_KRB_INC_WHERE1($i)
      if test "$ac_cv_found_krb_inc" = "yes"; then
        ac_cv_krb_where_inc=$i
	AC_MSG_RESULT(found)
	break
      else
	AC_MSG_RESULT(no found)
      fi
    done
])

#
# Test for kerberos lib files
#

AC_DEFUN(AC_KRB_LIB_WHERE1, [
saved_LIBS=$LIBS
LIBS="$saved_LIBS -L$1 -lkrb -ldes"
AC_TRY_LINK(,
[dest_tkt();],
[ac_cv_found_krb_lib=yes
 ac_cv_is_krb5=no],
ac_cv_found_krb_lib=no)
if test "$ac_cv_found_krb_lib" = "no"; then
  LIBS="$saved_LIBS -L$1 -lkrb4 -ldes425 -lkrb5 -lcrypto -lcom_err"
  AC_TRY_LINK(, 
  [dest_tkt();],
  [ac_cv_found_krb_lib=yes
   ac_cv_is_krb5=yes],
  ac_cv_found_krb_lib=no)
fi
LIBS=$saved_LIBS
])

AC_DEFUN(AC_KRB_LIB_WHERE, [
   for i in $1; do
      AC_MSG_CHECKING(for kerberos libraries in $i)
      AC_KRB_LIB_WHERE1($i)
      if test "$ac_cv_found_krb_lib" = "yes" ; then
        ac_cv_krb_where_lib=$i
	AC_MSG_RESULT(found)
	break
      else
	AC_MSG_RESULT(no found)
      fi
    done
])

AC_DEFUN(AC_HAVE__RES,[
  AC_CACHE_CHECK(_res,ac_cv_have__res,[
    AC_TRY_COMPILE(, u_long oldres = _res.options,
      [AC_DEFINE_UNQUOTED(HAVE__RES) 
       ac_cv_have__res=yes ], 
      ac_cv_have__res=no)])])

dnl
dnl output a C header-file with some version strings
dnl
AC_DEFUN(AC_KRB_VERSION,[
dnl AC_OUTPUT_COMMANDS([
cat > include/newversion.h.in <<FOOBAR
char *${PACKAGE}_long_version = "@(#)\$Version: $PACKAGE-$VERSION by @USER@ on @HOST@ ($host) @DATE@ \$";
char *${PACKAGE}_version = "$PACKAGE-$VERSION";
FOOBAR

if test -f include/version.h && cmp -s include/newversion.h.in include/version.h.in; then
	echo "include/version.h is unchanged"
	rm -f include/newversion.h.in
else
 	echo "creating include/version.h"
 	User=${USER-${LOGNAME}}
 	Host=`(hostname || uname -n) 2>/dev/null | sed 1q`
 	Date=`date`
	mv -f include/newversion.h.in include/version.h.in
	sed -e "s/@USER@/$User/" -e "s/@HOST@/$Host/" -e "s/@DATE@/$Date/" include/version.h.in > include/version.h
fi
dnl ],host=$host PACKAGE=$PACKAGE VERSION=$VERSION)
])


dnl
dnl AC_HAVE_FUNC_DECLARATION(func, includes)
dnl

AC_DEFUN(AC_HAVE_FUNC_DECLARATION, [
AC_CACHE_CHECK([for declaration of $1],
[
changequote(, )dnl
AC_EGREP_HEADER([^a-zA-Z_0-9]$1[^a-zA-Z_0-9], $2,
changequote([, ])dnl
ac_cv_func_$1=true)
])
: << END
@@@funcs="$funcs $1"@@@
END
eval "ac_tr_func=HAVE_[]upcase($1)"
if test "$ac_cv_func_$1" = "yes"; then
  AC_DEFINE_UNQUOTED($ac_tr_func)
  AC_MSG_RESULT([yes])
else
  AC_MSG_RESULT([no])
fi
])

dnl AC_HAVE_STRUCT_FIELD(includes, struct, type, field)
AC_DEFUN(AC_HAVE_STRUCT_FIELD, [
AC_MSG_CHECKING([if $2 has a field $4])
AC_CACHE_VAL(ac_cv_struct_$2_$4, [
AC_TRY_COMPILE([$1],
[struct $2 foo; $3 bar = foo.$4; ],
eval "ac_cv_struct_$2_$4=yes",
eval "ac_cv_struct_$2_$4=no")
])
changequote(, )dnl
eval "ac_tr_var=HAVE_STRUCT_`echo $2 | tr '[a-z]' '[A-Z]'`_`echo $4 | tr '[a-z]' '[A-Z]'`"
changequote([, ])dnl

define([foo], [[HAVE_STRUCT_]translit($2, [a-z], [A-Z])[_]translit($4, [a-z], [A-Z])])
: << END
@@@syms="$syms foo"@@@
END
undefine([foo])

AC_MSG_RESULT($ac_cv_struct_$2_$4)
if eval "test \"\$ac_cv_struct_$2_$4\" = yes"; then
	AC_DEFINE_UNQUOTED($ac_tr_var)
fi
])

dnl AC_HAVE_KERNEL_STRUCT_FIELD(includes, struct, type, field)
AC_DEFUN(AC_HAVE_KERNEL_STRUCT_FIELD, [
AC_MSG_CHECKING([if $2 has a field $4])
AC_CACHE_VAL(ac_cv_struct_$2_$4, [
AC_TRY_COMPILE_KERNEL([$1],
[struct $2 foo; $3 bar = foo.$4; ],
eval "ac_cv_struct_$2_$4=yes",
eval "ac_cv_struct_$2_$4=no")
])
changequote(, )dnl
eval "ac_tr_var=HAVE_STRUCT_`echo $2 | tr '[a-z]' '[A-Z]'`_`echo $4 | tr '[a-z]' '[A-Z]'`"
changequote([, ])dnl

define([foo], [[HAVE_STRUCT_]translit($2, [a-z], [A-Z])[_]translit($4, [a-z], [A-Z])])
: << END
@@@syms="$syms foo"@@@
END
undefine([foo])

AC_MSG_RESULT($ac_cv_struct_$2_$4)
if eval "test \"\$ac_cv_struct_$2_$4\" = yes"; then
	AC_DEFINE_UNQUOTED($ac_tr_var)
fi
])

dnl
dnl AC_CHECK_LFS
dnl



AC_DEFUN(AC_HAVE_GETCONF, [
AC_CHECK_PROG(ac_cv_prog_getconf,[getconf],yes)
])

AC_DEFUN(AC_GETCONF_FLAGS,[
if test "$ac_cv_prog_getconf" = "yes";then
AC_MSG_CHECKING([if we have $1])
FOO="`getconf $1 2>/dev/null >/dev/null`"
if test $? = 0 ;then
$2="[$]$2 $FOO"
AC_MSG_RESULT([yes $FOO])
else
AC_MSG_RESULT(no)
fi
fi

])

AC_DEFUN(AC_CHECK_LFS, [
if test "${ac_cv_prog_getconf-set}" = set ;then
AC_HAVE_GETCONF
fi
AC_GETCONF_FLAGS(LFS_CFLAGS, CFLAGS)
AC_GETCONF_FLAGS(LFS_LDFLAGS, LDFLAGS)
])


#
# test for GNU libc
#


AC_DEFUN(AC_CHECK_GLIBC,[
AC_CACHE_CHECK([for glibc],ac_cv_libc_glibc,[
AC_EGREP_CPP(yes,
[#include <features.h>
#ifdef __GLIBC__
yes
#endif
],
eval "ac_cv_libc_glibc=yes",
eval "ac_cv_libc_glibc=no")])
if test "$ac_cv_libc_glibc" = "yes";then
AC_DEFINE(HAVE_GLIBC)
fi
])

dnl
dnl Check for sa_len in sys/socket.h
dnl

AC_DEFUN(AC_STRUCT_SOCKADDR_HAS_SA_LEN, [
AC_MSG_CHECKING(for sa_len in struct sockaddr)
AC_CACHE_VAL(krb_cv_struct_sockaddr_sa_len, [
AC_TRY_COMPILE(
[#include <sys/types.h>
#include <sys/socket.h>],
[struct sockaddr sa;
int foo = sa.sa_len;],
krb_cv_struct_sockaddr_sa_len=yes,
krb_cv_struct_sockaddr_sa_len=no)
])
AC_MSG_RESULT($krb_cv_struct_sockaddr_sa_len)
if test "$krb_cv_struct_sockaddr_sa_len" = yes; then
	AC_DEFINE(SOCKADDR_HAS_SA_LEN)
fi
])

dnl
dnl AIX have a very different syscall convention
dnl
AC_DEFUN(AC_KRB_SYS_AIX, [
AC_MSG_CHECKING(for AIX)
AC_CACHE_VAL(krb_cv_sys_aix,
AC_EGREP_CPP(yes, 
[#ifdef _AIX
	yes
#endif 
], krb_cv_sys_aix=yes, krb_cv_sys_aix=no) )
AC_MSG_RESULT($krb_cv_sys_aix)
])

dnl $Id: aclocal.m4,v 1.45 1998/12/28 17:20:06 assar Exp $
dnl
dnl
dnl Check if we need the declaration of a variable
dnl

dnl AC_HAVE_DECLARATION(includes, variable)
AC_DEFUN(AC_CHECK_DECLARATION, [
AC_MSG_CHECKING([if $2 is properly declared])
AC_CACHE_VAL(ac_cv_var_$2_declaration, [
AC_TRY_COMPILE([$1
extern struct { int foo; } $2;],
[$2.foo = 1;],
eval "ac_cv_var_$2_declaration=no",
eval "ac_cv_var_$2_declaration=yes")
])

ac_tr_var=[HAVE_]translit($2, [a-z], [A-Z])[_DECLARATION]

define([foo], [HAVE_]translit($2, [a-z], [A-Z])[_DECLARATION])
: << END
@@@syms="$syms foo"@@@
END
undefine([foo])

AC_MSG_RESULT($ac_cv_var_$2_declaration)
if eval "test \"\$ac_cv_var_$2_declaration\" = yes"; then
	AC_DEFINE_UNQUOTED($ac_tr_var)
fi
])

dnl $Id: aclocal.m4,v 1.45 1998/12/28 17:20:06 assar Exp $
dnl
dnl AC_CHECK_VAR(includes, variable)
AC_DEFUN(AC_CHECK_VAR, [
AC_MSG_CHECKING(for $2)
AC_CACHE_VAL(ac_cv_var_$2, [
AC_TRY_LINK([extern int $2;
int foo() { return $2; }],
	    [foo()],
	    ac_cv_var_$2=yes, ac_cv_var_$2=no)
])
eval "ac_tr_var=[HAVE_]translit($2,[a-z],[A-Z])"

define([foo], [HAVE_]translit($2, [a-z], [A-Z]))
: << END
@@@syms="$syms foo"@@@
END
undefine([foo])

AC_MSG_RESULT(`eval echo \\$ac_cv_var_$2`)
if test `eval echo \\$ac_cv_var_$2` = yes; then
	AC_DEFINE_UNQUOTED($ac_tr_var)
	AC_CHECK_DECLARATION([$1],[$2])
fi
])
# from automake:
# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])
