/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: mbuf.h,v 1.5 1998/10/15 13:26:50 lha Exp $ */

#ifndef _MBUF_H_
#define _MBUF_H_

typedef enum { MBUF_READ = 1, MBUF_WRITE = 2, MBUF_ANON = 4 } mbuf_flags;

struct mbuf {
    void *buf;
    int fd;
    size_t off;
    size_t len;
    size_t reallen;
    mbuf_flags flags;
    int refcount;
};

typedef struct mbuf mbuf;

int mbuf_create (mbuf **mbuf, int fd, size_t off, size_t len, mbuf_flags flags);
int mbuf_resize (mbuf *mbuf, size_t off, size_t len);
int mbuf_truncate (mbuf *mbuf, size_t off, size_t len);
int mbuf_use (mbuf *mbuf);
int mbuf_end (mbuf *mbuf);

int mcopybuf2rx(struct rx_call *call, mbuf *buf, size_t off, size_t len);

int mcopyrx2fd (struct rx_call *call, int fd, size_t off, size_t len);
int mcopyfd2rx (int fd, struct rx_call *call, size_t off, size_t len);

#endif /* _MBUF_H_ */
