/* Escape and unescape URL encoding in strings. The functions return a new
 * allocated string or NULL if an error occurred.  */

#include <stdio.h>
#include <stdlib.h>

char *curl_escape(char *string)
{
   int alloc=strlen(string);
   char *ns = malloc(alloc);
   unsigned char in;
   int newlen = alloc;
   int index=0;

   while(*string) {
      in = *string;
      if(' ' == in)
	 ns[index++] = '+';
      else if(!(in >= 'a' && in <= 'z') &&
	      !(in >= 'A' && in <= 'Z') &&
	      !(in >= '0' && in <= '9')) {
	 /* encode it */
	 newlen += 2; /* the size grows with two, since this'll become a %XX */
	 if(newlen > alloc) {
	    alloc *= 2;
	    ns = realloc(ns, alloc);
	    if(!ns)
	       return NULL;
	 }
	 sprintf(&ns[index], "%%%02X", in);
	 index+=3;
      }
      else {
	 /* just copy this */
	 ns[index++]=in;
      }
      string++;
   }
   ns[index]=0; /* terminate it */
   return ns;
}

char *curl_unescape(char *string)
{
   int alloc = strlen(string);
   char *ns = malloc(alloc);
   unsigned char in;
   int index=0;
   int hex;
   

   while(*string) {
      in = *string;
      if('+' == in)
	 in = ' ';
      else if('%' == in) {
	 /* encoded part */
	 if(sscanf(string+1, "%02X", &hex)) {
	    in = hex;
	    string+=2;
	 }
      }

      ns[index++] = in;
      string++;
   }
   ns[index]=0; /* terminate it */
   return ns;
  
}
