#
# The backup server host
BackupHost:		backuphost
#
# The port number to use
#BackupPort:		2988
#
# The cartridge set to use
#CartridgeSet:		1

#
# The directory, where to run the backup
RootDirectory:		/
#
# The subdirectories of the RootDirectory to backup (wildcards are allowed)
DirsToBackup:		etc/HOSTNAME home* opt* users* usr/local
# Filenames to be skipped during the backup (wildcards are allowed)
FilesToSkip:		*.o *.obj core
# directory names to be skipped during the backup (wildcards are allowed)
DirsToSkip:		lost+found
# Name of a file containing a (pattern) list of files/directories to skip 
ExcludeListFile:	.buexcl

#
# The number of parts of the full backup (if this takes a long time)
NumBackupParts:		1
# The subdirectories of the RootDirectory to backup in parts
#DirsToBackup1:		mass-store/disk0 mass-store/disk1/part[0-1] home* opt* usr/lib/X11/ncd var/boot tftpboot
#DirsToBackup2:		mass-store/disk1/part[2-4] mass-store/disk1/[a-oq-z]*
#
# The compress and decompress programs, if desired.
CompressCmd:		gzip -1
UncompressCmd:		gunzip
#
# Which files no compression should be attempted
DoNotCompress:		*.gz *.z *.Z *.[Zz][Ii][Pp]
#
# Whether to compress the saved files
CompressBackupedFiles:	1
#

#
# The part of the file, where the saved filenames are stored.
# The current number will be appended.
IndexFilePart:		#BASEDIR#/client/var/backup_log.
#
# The number of such files, that are maintained. More (older ones) are removed.
NumIndexesToStore:	1
#
# The file where to log events
LoggingFile:		#BASEDIR#/client/var/backup.log
#
# Whether to compress the filename logfiles
CompressLogfiles:	1

#
# Filename with encryption key for authentication
EncryptionKeyFile:    #BASEDIR#/client/lib/cryptkey
#
# Directory for varying files
VarDirectory:		#BASEDIR#/client/var

#
# The program to process startup messages. Normally used for
#  saving logs to recover from hard crashs
StartupInfoProgram:	sh -c "[ -d /var/log ] && touch /var/log/bumsgs && cat >> /var/log/bumsgs";sh -c "[ -d /var/logs ] && touch /var/logs/bumsgs && cat >> /var/logs/bumsgs"
#
# The program to be executed when everything requested is done.
# %l is replaced by the filename-logfile, %r by the file with
# the report statistics %e by the overall exit status
ExitProgram:		(echo Overall exit status: %e;echo " ";cat %r; uuencode %l `basename %l`)|mail sysadmin
