.TH pemdbconv 1 "March 1995"  "7.1" "TIS/MOSS"
.SH NAME
pemdbconv \- convert from TIS/PEM 6 database to TIS/MOSS 7 database
.SH SYNOPSIS
.B pemdbconv
file 
.I filename
[private-key-access 
.I access
private-key 
.I data
][alias-file 
.I filename
]
.PP
or
.PP
.B pemdbconv 
cfile 
.I filename
[alias-file 
.I filename
]

.SH DESCRIPTION
Converts the named cfile or exported certificate or registration from
TIS/PEM 6 to a user record in a TIS/MOSS 7 database.
.B alias-file
can be used to name a TIS/PEM 6 alias file containing alias(es) for
the the certificate being converted so that the same aliases will
automatically be created in the new user record.
.PP
Both
.B private-key-access
and
.B private-key
tag/value pairs must be included if you are processing an exported 
registration and you want to save the private key.  For now,
.I access
must be the word 
.B file
and 
.I data
must contained the fully qualified file name into which the private
key is to be placed.
.PP 
If you are exporting a registration and intend to use it as the
default user record for generating signatures, you must add an
.B alias
tag/value pair to the user record containing the value associated with 
the 
.B sig-alias
tailorable tag/value pair (
.B sig-user
by default).
If you are exporting a registration you should also add an 
.B alias
tag/value pair to the user record containing the value associated with
the
.B my-alias
tailorable tag/value pair (
.B me
by default) if you intend to receive messages encrypted for this user
record.
.SH FILES
$HOME/.mossrc,
$HOME/.mossdb
.SH SEE ALSO
mossdb(5), mossrc(5), mosskey(1), moss(1)
.SH BUGS
Does not encrypt private key.  Must run
.B mosspass 
to do so.

