/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include <sys/stat.h>
#include <errno.h>
#include "general.h"

#include "util.h"

/*
 * return -1 on error, 0 if no error, 1 if check failed
 *
 * if "mode" is less than 0 the permissions check is not done,
 * but it is an error to pass a negative number when creating
 */

fdchk(fd, mode)
int fd, mode;
{
    struct stat sbuf;

    if (fstat(fd, &sbuf)) 
	return(-1);

    if ((sbuf.st_mode & S_IFMT) != S_IFREG) 
	return(1);

    if (mode != NOPERMS && ((sbuf.st_mode & 0777) | mode) != mode) 
	return(1);

    if (mode != NOPERMS && mode & 0222 && sbuf.st_uid != getuid()) 
	return(1);
    
    return(0);
}
