/* This is the yacc grammar definition for MOSS messages */

%{
#include "config.h"

#include <stdio.h>

#include "general.h"

#include "bbuf.h"
#include "dname.h"
#include "msg.h"
#include "util.h"

struct msg		*msg= NULL_MSG;
static struct bbuf	*bb= NULLBB;
static struct bbuf      bbuf;

static char             *dnstr = NULLCP;
static char             **ids = NULLVP;

static struct user_list *ul = NULLUL;

static char             *dekinfo= NULLCP,
			*edek= NULLCP,
			*keyalg = NULLCP,
			*sig= NULLCP;

%}

%union { char str[BUFSIZ]; }

%token BLANKLINE DEKINFO KEYINFO ORIGID RECIPID MICINFO VRSION
%token ID_EN ID_STR ID_DN ID_PK ID_IS
%token <str> STR HSTR 

%%

Msg :			EncryptedMsg
                	| SignedMsg
			;

EncryptedMsg :		EncryptedHeaders ;

SignedMsg :		SignedHeaders ;

EncryptedHeaders :	VersionHeader DEKHeader RecipKeyHeaders {
			    bb = alloc_bbuf();
			    bb->length=strlen(dekinfo);
			    bb->data = (unsigned char *)dekinfo;
			    msg->dekinfo = bb;
			    bb = NULLBB;
			    dekinfo = NULLCP;
			} 
			;

SignedHeaders :		VersionHeader OrigMicHeaders 
			;
			
VersionHeader :		VRSION HSTR {
			    if (strcmp($2, "5"))
				return(1);
			    msg->comment = 
			        add2av(msg->comment,
				       add2cp(NULLCP,"Version: 5"));
			}
			;

RecipKeyHeaders :	RECIPIDHeader KEYHeader {

			    if ((bb = hdr2bbuf(edek)) == NULLBB)
				return 1;
			    bb->next = msg->recipkey;
			    msg->recipkey = bb;
			    bb = NULLBB;
			    FREE(edek);

			    bb = alloc_bbuf();
			    bb->length = strlen(keyalg);
			    bb->data = (unsigned char *)keyalg;
			    bb->next = msg->keyalg;
			    msg->keyalg = bb;
			    bb = NULLBB;
			    keyalg = NULLCP;

			    if (ids == NULLVP)
			        return 1;
			    ul = alloc_ul();
			    ul->user = ids;
			    ids = NULLVP;
			    ul->next = msg->recipusers;
			    msg->recipusers = ul;
			    ul = NULLUL;

			}
                        | RecipKeyHeaders RECIPIDHeader KEYHeader {

			    if ((bb = hdr2bbuf(edek)) == NULLBB)
				return 1;
			    bb->next = msg->recipkey;
			    msg->recipkey = bb;
			    bb = NULLBB;
			    FREE(edek);

			    bb = alloc_bbuf();
			    bb->length = strlen(keyalg);
			    bb->data = (unsigned char *)keyalg;
			    bb->next = msg->keyalg;
			    msg->keyalg = bb;
			    bb = NULLBB;
			    keyalg = NULLCP;

                            if (ids == NULLVP)
                                return 1;
                            ul = alloc_ul();
                            ul->user = ids;
                            ids = NULLVP;
                            ul->next = msg->recipusers;
                            msg->recipusers = ul;
                            ul = NULLUL;

			} ;
			
OrigMicHeaders :	ORIGIDHeader MICHeader {

                            if (ids == NULLVP)
                                return 1;
                            ul = alloc_ul();
                            ul->user = ids;
                            ids = NULLVP;
                            ul->next = msg->origusers;
                            msg->origusers = ul;
                            ul = NULLUL;

			    bb = alloc_bbuf();
			    bb->length = strlen(keyalg);
			    bb->data = (unsigned char *)keyalg;
			    bb->next = msg->keyalg;
			    msg->keyalg = bb;
			    bb = NULLBB;
			    keyalg = NULLCP;

			    if ((bb = hdr2bbuf(sig)) == NULLBB)
				return 1;
			    bb->next = msg->signature;
			    msg->signature = bb;
			    bb = NULLBB;
	                    FREE(sig);
			}
			| OrigMicHeaders ORIGIDHeader MICHeader {

                            if (ids == NULLVP)
                                return 1;
                            ul = alloc_ul();
                            ul->user = ids;
                            ids = NULLVP;
                            ul->next = msg->origusers;
                            msg->origusers = ul;
                            ul = NULLUL;

			    bb = alloc_bbuf();
			    bb->length = strlen(keyalg);
			    bb->data = (unsigned char *)keyalg;
			    bb->next = msg->keyalg;
			    msg->keyalg = bb;
			    bb = NULLBB;
			    keyalg = NULLCP;

			    if ((bb = hdr2bbuf(sig)) == NULLBB)
				return 1;
			    bb->next = msg->signature;
			    msg->signature = bb;
			    bb = NULLBB;
	                    FREE(sig);
			} ;

	/* Define Algorithms by type */
DEKAlg :	HSTR { msg->dekalg = add2cp(NULLCP, $1); }
                ;

SigAlg :	HSTR { msg->sigalg = add2cp(NULLCP, $1); }
		;

KeyAlg :	HSTR { keyalg = add2cp(NULLCP, $1); } 
		;

DEKHeader :     DEKINFO DEKAlg HSTR { dekinfo = add2cp (NULLCP, $3); }
                | DEKHeader HSTR { dekinfo = add2cp(dekinfo, $2); }
		;

KEYHeader :     KEYINFO KeyAlg HSTR { edek = add2cp (NULLCP, $3); }
                | KEYHeader HSTR { edek = add2cp(edek, $2); }
		;

IDValue :	NameID | ID_publickey | ID_issuer ;

NameID :	ID_email | ID_string | ID_dname ;

ID_email :	ID_EN HSTR HSTR {
		       /* EN, keyid, email-address */
                       ids = add2av (ids, add2cp (NULLCP, "id-en"));
                       ids = add2av (ids, add2cp (NULLCP, $3));
		       ids = add2av (ids, add2cp (NULLCP, "id-en-keyid"));
                       ids = add2av (ids, add2cp (NULLCP, $2));
		};

ID_string :	ID_STR HSTR HSTR {
		       /* STR, keyid, string */
                       ids = add2av (ids, add2cp (NULLCP, "id-str"));
                       ids = add2av (ids, add2cp (NULLCP, $3));
                       ids = add2av (ids, add2cp (NULLCP, "id-str-keyid"));
                       ids = add2av (ids, add2cp (NULLCP, $2));
		};

ID_dname :	ID_DN HSTR HSTR {
			/* DN, keyid, dname */
                       ids = add2av (ids, add2cp (NULLCP, "id-dn"));
                       ids = add2av (ids, add2cp (NULLCP, $3));
                       ids = add2av (ids, add2cp (NULLCP, "id-dn-keyid"));
                       ids = add2av (ids, add2cp (NULLCP, $2));
		};

ID_publickey :	ID_PK HSTR NameID {
		       /* PK, publickey, NameID */
                       ids = add2av (ids, add2cp (NULLCP, "public-key"));
		       ids = add2av (ids, add2cp (NULLCP, $2));
		};
		| ID_PK HSTR {
		       /* PK, publickey */
		       ids = add2av (ids, add2cp (NULLCP, "public-key"));
		       ids = add2av (ids, add2cp (NULLCP, $2));
		};

ID_issuer :	ID_IS HSTR HSTR {
		       /* IS, dname, serial */
                       bbuf.data = (unsigned char *) $2;
		       bbuf.length = strlen($2);
		       if (bdecode(&bbuf, &bb) != OK)
			   return 1;
		       dnstr = dn2str(bb);
		       FREE_BBUF(bb);
		       if (dnstr == NULLCP)
			   return 1;
                       ids = add2av (ids, add2cp (NULLCP, "issuer-name"));
		       ids = add2av (ids, add2cp (NULLCP, dnstr));
		       FREE(dnstr);
		       ids = add2av (ids, add2cp (NULLCP, "serial-number"));
		       ids = add2av (ids, add2cp (NULLCP, $3));
		};

/* keyid is a printably encoded non-null sequence of octets */
/* emailstr must be RFC 822 but forget about validating here */
/* string is a non-null sequence of us-ascii characters */
/* dname is a printably encoded ASN.1 encoded distinguished name */
/* publickey is a printably encoded ASN.1 encoded subjectPublicKeyInfo */
/* serial is non-null hex dump of the serial number */

ORIGIDHeader :  ORIGID IDValue ;

RECIPIDHeader :  RECIPID IDValue ;

MICHeader :     MICINFO SigAlg KeyAlg HSTR { sig = add2cp (NULLCP, $4); }
                | MICHeader HSTR { sig = add2cp(sig, $2); }
		;

%%
