/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"

int moss_getkeydata(firstuser, chaintype, iocbs)
char **firstuser;
char *chaintype;
struct cbstruct *iocbs;
{
    int r          = NOTOK;
    int certchain;
    int crlchain;
    int keychain;
    int getcrl;
    int found;
    char **av;
    char **user    = NULLVP;
    char **tmpuser = NULLVP;
    char **cert    = NULLVP;
    char **crl     = NULLVP;
    char *dn       = NULLCP;
    char *olddn    = NULLCP;
    char *id       = NULLCP;
    char *cp       = NULLCP;

    if (firstuser == NULLVP || iocbs == NULL_IOCBS || iocbs->out_hdrs
	== NULL_OUTCB)
	goto cleanup;

    certchain = !strcasecmp(chaintype, "certificate");
    crlchain  = !strcasecmp(chaintype, "crl");
    keychain  = !strcasecmp(chaintype, "key");

    if (!certchain && !crlchain && ! keychain) {
	cp = add2cp(NULLCP, "Unknown key data chain type \"");
	cp = add2cp(cp, chaintype);
	cp = add2cp(cp, "\".\n");
	cp2cb(iocbs->out_errs, cp);
	FREE(cp);
	goto cleanup;
    }

    if (keychain) {
	if ((id = id_user(firstuser, 1, 1)) == NULLCP) {
	    cp2cb(iocbs->out_errs, 
		  "Unable to generate an ID for supplied user.\n");
	    goto cleanup;
	}
	cp = add2cp(NULLCP, "Key: ");
	cp = add2cp(cp, id);
	cp = add2cp(cp, "\n");
	cp2cb(iocbs->out_hdrs, cp);
	FREE(cp);
    } 
    else {

	/* Set up for first time through cert/crl  loop */

	getcrl = crlchain;
	user = dupav(firstuser);
	cert = tag_user(user, "certificate");
	crl = tag_user(user, "crl");

	if ((certchain && cert == NULLVP) ||
	    (crlchain && crl == NULLVP)) {
	    cp = add2cp(NULLCP, "Missing initial ");
	    if (certchain)
		cp = add2cp(cp, "certificate");
	    else
		cp = add2cp(cp, "CRL");
	    cp = add2cp(cp, " for chain.\n");
	    cp2cb(iocbs->out_errs, cp);
	    FREE(cp);
	    goto cleanup;
	}
    
	if ((av = tag_user(user, "subject-name")) == NULLVP)
	    if (cert!= NULLVP && (tmpuser = explode_cert(*(cert+1)))!= NULLVP)
		av = tag_user(tmpuser, "subject-name");
	if (av != NULLVP)
	    dn = add2cp (NULLCP, *(av+1));
	FREE_AV(tmpuser);

	/* Follow the chain as far as we can */

	while (cert != NULLVP && (crl != NULLVP || certchain)) {
	    
	    /* Output CRL */
	    if (getcrl && crl != NULLVP) {
		cp = add2cp(NULLCP, "CRL: ");
		cp = add2cp(cp, *(crl+1));
		cp = add2cp(cp, "\n");
		cp2cb(iocbs->out_hdrs, cp);
		FREE(cp);
	    }
	    getcrl = 1;
	    
	    /* Output Certificate */
	    cp = add2cp(NULLCP, "Certificate: ");
	    cp = add2cp(cp, *(cert+1));
	    cp = add2cp(cp, "\n");
	    cp2cb(iocbs->out_hdrs, cp);
	    FREE(cp);

	    /* Determine issuer's name for next user in chain */
	    if ((av = tag_user(user, "issuer-name")) == NULLVP) 
		if ((tmpuser = explode_cert(*(cert+1))) != NULLVP)
		    av = tag_user(tmpuser, "issuer-name");
	    if (av == NULLVP) 
		goto cleanup;
	    
	    
	    FREE(olddn);
	    olddn = dn;
	    dn = add2cp (NULLCP, *(av+1));
	    FREE_AV(tmpuser);
	    
	    /* Make sure we're not self-signed */
	    if (olddn != NULLCP && !strcmp(olddn, dn))
		break;
	    
	    /* get next user in chain */
	    FREE_AV(user);
	    rewind_indexfile();
	    found = 0;
	    while (!found && (user = get_indexfile()) != NULLVP) {
		if ((cert = tag_user(user, "certificate")) != NULLVP) {
		    if ((av = tag_user(user, "subject-name")) == NULLVP) 
			if ((tmpuser = explode_cert(*(cert+1))) != NULLVP)
			    av = tag_user(tmpuser, "subject-name");
		    if (av != NULLVP && !strcmp(dn, *(av+1))) {
			crl = tag_user(user, "crl");
			found = 1;
		    }
		    else {
			cert = NULLVP;
			crl = NULLVP;
		    }
		    FREE_AV(tmpuser);
		}
	    }
	}
    }

    r = OK;

 cleanup:

    FREE_AV(user);
    FREE(id);
    FREE(dn);
    FREE(olddn);
    return r;

}
