/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/* leading and trailing whitespace is deleted; multiple occurrences of
 * whitespace is collapsed to a single space
 */

#include "config.h"
#include "general.h"

trim_whitesp(cp)
char *cp;
{
    char *ptr;
    int   i, j, cplen;

    if (cp == NULLCP)
	return(OK);

    /* Convert all whitespace characters to spaces */

    for (ptr = cp; *ptr != NULLC; ptr++)
	if (*ptr == '\b' || *ptr == '\f' || *ptr == '\n' || *ptr == '\r' ||
	    *ptr == '\t' || *ptr == '\v')
	    *ptr = ' ';

    /* Trim leading spaces */

    cplen = strlen(cp);
    for (i = 0; i < cplen && cp[i] == ' '; i++)
	;
    if (i)
	for (j = i; j <= cplen; j++)
	    cp [j-i] = cp [j];
    
    /* Trim trailing spaces */

    cplen -= i;
    for (i = cplen - 1; i >= 0 && cp[i] == ' '; i--)
	cp[i] = NULLC;

    /* Compress internal spaces */

    j = 2;
    cplen = strlen(cp);
    for (i = 2; i <= cplen; i++)
	if (cp[i] != ' ' || cp[j-1] != ' ')
	    cp[j++] = cp[i];

    return(OK);
}
