/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



/* given a user record, return a string that can be printed to 
 * identify the user.
 */

#include "general.h"
#include "new.h"
#include "util.h"

char *pretty_user(user)
char **user;
{
    char **av;
    char *id;
    char *pretty;

    if ((av = tag_user(user, "display")) != NULLVP) {
	pretty = add2cp(NULLCP, "user ");
	pretty = add2cp(pretty, *(av+1));
    }
    else if ((av = tag_user(user, "alias")) != NULLVP) {
	pretty = add2cp(NULLCP, "user with alias ");
	pretty = add2cp(pretty, *(av+1));
    }
    else if ((id = id_user(user, 0, 0)) != NULLCP) {
	pretty = add2cp(NULLCP, "user with identifier ");
	pretty = add2cp(pretty, id);
	FREE(id);
    }
    else 
	pretty = add2cp(NULLCP, "Unable to display user.");

    return pretty;
}

