/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/****************************************************************************
 * disp_algid.c
 ****************************************************************************/

#include <stdio.h>

#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "util.h"

disp_algid(aid, out)
struct algid *aid;
char ***out;
{
    char *alg = NULLCP;
    struct algent *ae = NULL_ALGENT;
    struct ccbent *ce = NULL_CCBENT;
    int r;

    /* DOUBLE-CHECK FUNCTION PARAMETERS */
    if (out == (char ***)0) 
	return(NOTOK);

    /* CHECK FOR NULL ALGID */
    if (aid == NULL_ALGID) {
	*out = add2av(*out, add2cp(NULLCP,"NULL"));
	return(OK);
    }

    /* DISPLAY ALGID.ALG */
    alg = add2cp(alg, "algorithm: ");
    if ((ae = getalgcode(algorithms, aid->alg, ANY)) == NULL_ALGENT) {
	r = NOTOK;
	goto cleanup;
    }
    if (ae->str == NULLCP) {
	alg = add2cp(alg, "NOSTRING(");
	alg = addint2cp(alg, ae->code);
	alg = add2cp(alg, ")");
    } else
	alg = add2cp(alg, ae->str);
    *out = add2av(*out, alg);

    /* DISPLAY ALGID.PARMS VIA ALGORITHM-SPECIFIC FUNCTION */
    if (aid->parms == NULLBB)
        *out = add2av(*out, add2cp (NULLCP, "parameters: NULL"));
    else {
        if ((ce = getccbcode(callbacks, aid->alg)) == NULL_CCBENT) {
	    r = NOTOK;
	    goto cleanup;
        }
        if (ce->disp_Xkeyparms == NULL_FUNC) {
	    r = NOTOK;
	    goto cleanup;
        }
        if ((r = (*(ce->disp_Xkeyparms))(aid->alg, aid->parms, out)) != OK)
	    goto cleanup;
    }

    r = OK;

 cleanup:

    if (r != OK)
	FREE_AV(*out);

    return(r);
}

