/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*****************************************************************************
 * encode_rcl.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

encode_rcl(drcl,ercl)
struct rcl_entry *drcl;
struct bbuf **ercl;
{
    int r = OK;
    struct bbuf *bb = NULLBB, *bb2= NULLBB, *bb3= NULLBB;
    struct rcl_entry *trcl;

    /* CHECK OUTPUT PARAMETERS */
    if (ercl == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*ercl);

    /* ENCODE NULL RCL_ENTRY AS A NULLBB */
    if (drcl == NULL_RCL_ENTRY)
	goto cleanup;

    /* ENCODE THE RCL ENTRIES */
    for (trcl = drcl; trcl != NULL_RCL_ENTRY; trcl = trcl->next) {
	if ((r = encode_rcl_entry(trcl, &bb)) != OK)
	    goto cleanup;
	 bb3 = bbufcat(bb2, bb);
	 FREE_BBUF(bb);
	 FREE_BBUF(bb2);
	 bb2 = bb3;
    }

    /* ENCODE THE LENGTH & PREPEND */
    if ((r = encode_len(bb2->length, &bb)) != OK)
        goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND THE TAG */
    if ((r = encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
	goto cleanup;
    *ercl = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    r = OK;

 cleanup:

    if (r != OK)
        FREE_BBUF(*ercl);

    FREE_BBUF(bb2);

    return(r);
}

/*****************************************************************************/

encode_rcl_entry(drcl,ercl)
struct rcl_entry *drcl;
struct bbuf **ercl;
{
    int r = OK;
    struct bbuf *bb = NULLBB, *bb2 = NULLBB, *bb3 = NULLBB;

    /* CHECK PARAMETERS */
    if (ercl == (struct bbuf **)0) 
	return(NOTOK);

    FREE_BBUF(*ercl);

    /* ENCODE NULL RCL_ENTRY AS A NULL */
    if (drcl == NULL_RCL_ENTRY) {
	r = encode_null(CLASS_UNIV|FORM_CONS|CONS_SEQ, ercl);
	goto cleanup;
    }

    /* ENCODE THE SERIAL NUMBER */
    if ((r = encode_ints(drcl->serial, &bb2)) != OK)
	goto cleanup;

    /* ENCODE THE DATE & APPEND */
    if ((r = encode_utct(drcl->date, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb2, bb);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* ENCODE THE LENGTH & PREPEND */
    if ((r = encode_len(bb2->length, &bb)) != OK)
	goto cleanup;
    bb3 = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);
    bb2 = bb3;

    /* PREPEND THE TAG */
    if ((r = encode_tag(CLASS_UNIV|FORM_CONS|CONS_SEQ, &bb)) != OK)
        goto cleanup;
    *ercl = bbufcat(bb, bb2);
    FREE_BBUF(bb);
    FREE_BBUF(bb2);

    r = OK;

cleanup:

    if (r != OK)
        FREE_BBUF(*ercl);

    FREE_BBUF(bb2);

    return(r);
}

