/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"

#include <stdio.h>

#include "general.h"

#include "bbuf.h"
#include "util.h"

struct bbuf *cbmemread(array, done)
char *array;
int *done;
{
    /* The int pointed to by done must initialized to zero in the main
       program.  It is then set to one here to prevent the array from
       being read over and over.
     */

    struct bbuf *buf = NULLBB;

    if (! *done) {
	*done = 1;
	buf = alloc_bbuf();
	buf->length = sizeof(*array);
	buf->data = alloc_uchar(buf->length);
	BCOPY(array, buf->data, buf->length);
    }

    return (buf);
}

int cbmemwrite(buf, array)
struct bbuf *buf;
char **array;
{
    if (buf == NULLBB || buf->data == NULLUCP)
	return(0);

    if (buf->length == 0 || array == NULLVP)
	return(1);

    if (*array == NULL) 
	*array = alloc_char(buf->length);
    else {
	if ((*array = realloc(*array,
			      (unsigned)(sizeof(*array) + buf->length)))
	    == NULLCP)
	    return(0);
    }

    BCOPY(buf->data, *array + sizeof(*array) - buf->length, buf->length);
    return (1);
}
