/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"

#include <stdio.h>

#include "general.h"
#include "bbuf.h"
#include "util.h"

struct bbuf *cbfread(file)
FILE *file;
{
    struct bbuf *buf;

#ifndef PC
    if (file == (FILE *)0) 
	return(NULLBB);
#endif

    buf = alloc_bbuf();
    buf->data = alloc_uchar(BUFSIZ);
#ifndef PC
    buf->length = fread((char *)buf->data, 1, BUFSIZ, file);
#else
    buf->length = pc_read((char *)buf->data, 1, BUFSIZ);
#endif

    return(buf);
}


struct bbuf *cbfneread(file)    /*  Just like cbfread() w/o echo */
FILE *file;
{
    struct bbuf *buf = NULLBB;
    int fd;
    int was_echo;

    fd = fileno(file);
    if ((was_echo = ttyecho(fd, 0)) != -1) {
#ifdef PC      
	if (fd == 0)
	    file = (FILE *)0;
#endif
        buf = cbfread(file);
        (void) ttyecho(fd, was_echo);
    }
    return(buf);
}


int cbfwrite(file, buf)
FILE *file;
struct bbuf *buf;     
{
    if (file == (FILE *)0 || buf == NULLBB || buf->data == NULLUCP)
	return (0);

    if (buf->length == 0) {
	(void) fflush(file);
	return(1);
    }

    return(fwrite((char *)buf->data, 1, buf->length, file) == buf->length);
}

