/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

struct bbuf *prim2bits(prim)
struct bbuf *prim;
{
    struct bbuf *bb;
    int blength;
    int i;
    unsigned char *Sp, *dp;
	
    if (prim == NULLBB || prim->length < 2) 
	return(NULLBB);

    bb = alloc_bbuf();
    bb->data = alloc_uchar(prim->length-1);

    bb->length = prim->length - 1;
    blength = bb->blength = prim->data[0];
    for(i = 1, Sp = prim->data + 1, dp = bb->data; i < prim->length;
	i++, Sp++, dp++){
	*dp |= *Sp >> blength;
	if (i + 1 < prim->length)
	    *(dp+1) = *Sp << 8 - blength;
    }

    return(bb);
}
