/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


/*
 * $XConsortium: compfuncs.c,v 2.17 89/10/06 15:02:26 converse Exp $
 *
 *
 * 		      COPYRIGHT 1987, 1989
 *		   DIGITAL EQUIPMENT CORPORATION
 *		       MAYNARD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
 * DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Digital Equipment Corporation not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 */

/* comp.c -- action procedures to handle composition buttons. */

#include <stdio.h>     
#include "xmh.h"
#include "mossdef.h"

typedef char* Pointer;
static void FreeStatus();
typedef struct _CommandStatus {
    Widget      popup;           /* must be first; see PopupStatus */
    struct _LastInput lastInput; /* must be second; ditto */
    char*       shell_command;   /* must be third; for XmhShellCommand */
    int         child_pid;
    XtInputId   output_inputId;
    XtInputId   error_inputId;
    int         output_pipe[2];
    int         error_pipe[2];
    char*       output_buffer;
    int         output_buf_size;
    char*       error_buffer;
    int         error_buf_size;
} CommandStatusRec, *CommandStatus;


/* Reset this composition widget to be one with just a blank message
   template. */

/*ARGSUSED*/
void DoResetCompose(widget, client_data, call_data)
    Widget	widget;		/* unused */
    XtPointer	client_data;
    XtPointer	call_data;	/* unused */
{
    Scrn	scrn = (Scrn) client_data;
    Msg		msg;
    XtCallbackRec	confirms[2];

    confirms[0].callback = (XtCallbackProc) DoResetCompose;
    confirms[0].closure = (XtPointer) scrn;
    confirms[1].callback = (XtCallbackProc) NULL;
    confirms[1].closure = (XtPointer) NULL;

    if (MsgSetScrn((Msg) NULL, scrn, confirms, (XtCallbackList) NULL) ==
	NEEDS_CONFIRMATION)
	return;

    msg = TocMakeNewMsg(DraftsFolder);
    MsgLoadComposition(msg);
    MsgSetTemporary(msg);
    MsgSetReapable(msg);
    (void) MsgSetScrn(msg, scrn, (XtCallbackList) NULL, (XtCallbackList) NULL);
}

/*
 * remove_space() : To remove any preceeding and trailing spaces from the string.
 */
static
void remove_space(string)
     char  *string;
{
     char   buf[512];
     char  *ptr;

     /* Simply use strtok */
     strcpy(buf,string);
     ptr = strtok(buf," ");
     if (ptr != NULL ) {
	  strcpy(string,ptr);
     }
     else {
	  string[0] = '\0';
     }

} /* remove_space() */

/*
 * IsMOSSDirectiveFirstLine() : Return True if a PEM directive is found on  
 *                             first line of the specified file (also returns 
 *                             indication of which directive was found, if 
 *                             any). Else, return False.
 */
static
Boolean IsMOSSDirectiveFirstLine(filename,op)
     char    *filename;    /* pathname of file */
     MOSS_Op  *op;
{
     FILE   *file;       /* stream pointer to compose file */
     char    buf[512];

     /* Open file for reading */
     if ( (file = fopen(filename,"r")) == NULL ) {
	  /* No error recovery possible but to return with False ret value */
	  return(False);
     }

     /* Initialize buf */
     buf[0] = '\0';
     
     /* Read up to carriage return or semi-colon */
     fscanf(file,"%[^;\n]",buf);

     /* Make sure to close stream */
     fclose(file);

     /* Check that the first character is a pound sign */
     if ( buf[0] != '#' ) {
	  return(False);
     }

     /* Determine which directive was found */

     /* replace # by blank before calling remove_space() */
     buf[0] = ' ';

     /* remove any preceeding and trailing whitespace */
     remove_space(buf);

     if ( strcmp(buf,"sign") == 0 ) {
	  *op = MOSS_SIGN;
     }
     else if ( strcmp(buf,"encrypt") == 0 ) {
	  *op = MOSS_ENCRYPT;
     }
     else if ( strcmp(buf,"privacy") == 0 ) {
	  *op = MOSS_SIGN_ENCRYPT; /* -privacy is equivalent to -sign -encrypt */
     }
     else {
	  *op = MOSS_UNKNOWN_OP;
     }

     /* 
      * Even if we didn't find any of the expected directives, return True to
      * indicate that a pound sign was detected as the first character in the
      * file.
      */
     return(True);

} /* IsMOSSDirectiveFirstLine() */


/*
 * PerformMOSSOperation() : Perform the PEM operation as specified by op 
 *                          parameter for the composition window referenced by 
 *                          scrn. Returns -1 if error, else returns 0.
 */
static
int  PerformMOSSOperation(scrn,op)
     Scrn    scrn;
     MOSS_Op  op;
{
     char **argv;
     char   filename[100];

     /* Check first if user has logged into MOSS */
     if (ChkMOSSLogStat() == QUIT) return(-1);

     /* Check that msg is not NULL */
     if (scrn->msg == NULL) return(-1);

     /* Set busy cursor */
     if (app_resources.block_events_on_busy) ShowBusyCursor();

     /* First, apply changes of text source to draft file */
     (void) MsgSaveChanges(scrn->msg);

     /* Now, call routine to perform MOSS enhacement to draft file */
     strcpy(filename,MsgFileName(scrn->msg));

     /* 
      * Call sendproc with the appropriate options to perform MOSS
      * service with the appropriate options.
      */
     switch ( op ) {
	case MOSS_NOSEND:
	  argv = MakeArgv(4);  
	  argv[0] = sendproc;
	  argv[1] = "-noverbose";
	  argv[2] = "-nosend";
	  argv[3] = filename;
	  break;
	case MOSS_SIGN:
	  argv = MakeArgv(5);  
	  argv[0] = sendproc;
	  argv[1] = "-noverbose";
	  argv[2] = "-nosend";
	  argv[3] = "-sign";
	  argv[4] = filename;
	  break;
	case MOSS_ENCRYPT:
	  argv = MakeArgv(5);  
	  argv[0] = sendproc;
	  argv[1] = "-noverbose";
	  argv[2] = "-nosend";
	  argv[3] = "-encrypt";
	  argv[4] = filename;
	  break;
	case MOSS_SIGN_ENCRYPT:
	  argv = MakeArgv(5);  
	  argv[0] = sendproc;
	  argv[1] = "-noverbose";
	  argv[2] = "-nosend"; 
	  argv[3] = "-privacy";      /* equivalent to -sign -encrypt */
	  argv[4] = filename;
	  break;
	default:
	  if (app_resources.block_events_on_busy) UnshowBusyCursor();
	  return(-1);
	  break;
     }

     /* 
      * DoCommand() will bring up a popup notice if sendproc writes anything
      * to stderr.
      */
     if ( DoCommand(argv, (char *) NULL, (char *) NULL) == -1 ) {
	  if (app_resources.block_events_on_busy) UnshowBusyCursor();
	  XtFree((char*) argv); 
	  return(-1);
     }

     /* Free memory holding argument list */
     XtFree((char*) argv);
     
     /* 
      * Set the msg as being a MOSS enhanced message and as *not* being 
      * repeable.
      */
     MsgSetAsMOSSEnhanced(scrn->msg);
     MsgClearReapable(scrn->msg);   
     
     /* Read in the draft file with MOSS enhancments */
     MsgReadInFile(scrn->msg,filename);
     
     /* Unset busy cursor */
     if (app_resources.block_events_on_busy) UnshowBusyCursor();
     
     /* Make sure Send button is enabled if operation is not MOSS_NOSEND */
     if ( op != MOSS_NOSEND ) {
	  BBoxEnable( BBoxFindButtonNamed(scrn->viewbuttons, "send"));
     }

     /* No errors */
     return(0);

	
} /* PerformMOSSOperation() */


/*ARGSUSED*/
void DoMOSSSignOnly(widget, client_data, call_data)
    Widget	widget;		/* unused */
    XtPointer	client_data;
    XtPointer	call_data;	/* unused */
{
    Scrn   scrn = (Scrn)  client_data;

    /* Call routine to do all the work */
    (void)PerformMOSSOperation(scrn,MOSS_SIGN);

}

/*ARGSUSED*/
void DoMOSSEncryptOnly(widget, client_data, call_data)
    Widget	widget;		/* unused */
    XtPointer	client_data;
    XtPointer	call_data;	/* unused */
{

    Scrn   scrn = (Scrn)  client_data;

    /* Call routine to do all the work */
    /* (void)PerformMOSSOperation(scrn,MOSS_ENCRYPT); */
    PopupNotice(MOSS_NOT_SUPPORTED2, FreeStatus, (Pointer) NULL);

}

/*ARGSUSED*/
void DoMOSSSignEncrypt(widget, client_data, call_data)
    Widget	widget;		/* unused */
    XtPointer	client_data;
    XtPointer	call_data;	/* unused */
{

    Scrn   scrn = (Scrn)  client_data;

    /* Call routine to do all the work */
    /* (void)PerformMOSSOperation(scrn,MOSS_SIGN_ENCRYPT); */
    PopupNotice(MOSS_NOT_SUPPORTED, FreeStatus, (Pointer) NULL);

}


/*ARGSUSED*/
void XmhResetCompose(w, event, params, num_params)
    Widget	w;
    XEvent	*event;
    String	*params;
    Cardinal	*num_params;
{
    Scrn scrn = ScrnFromWidget(w);
    DoResetCompose(w, (XtPointer) scrn, (XtPointer) NULL);
}


/* Send the message in this widget.  Avoid sending the same message twice.
   (Code elsewhere actually makes sure this button is disabled to avoid
   sending the same message twice, but it doesn't hurt to be safe here.) */

/*ARGSUSED*/
void XmhSend(w, event, params, num_params)
    Widget	w;
    XEvent	*event;
    String	*params;
    Cardinal	*num_params;
{
    Scrn      scrn = ScrnFromWidget(w);
    char      filename[100];
    MOSS_Op    op;

    if (scrn->msg == NULL) return;

    if (MsgChanged(scrn->msg) || ! MsgGetReapable(scrn->msg) ) {

	 /* Retrieve filename */
	 strcpy(filename,MsgFileName(scrn->msg));

	 /* 
	  * Apply changes of text source to draft file before calling
	  * IsMOSSDirectiveFirstLine() is called.
	  */
	  (void) MsgSaveChanges(scrn->msg);

	 /* Check for directive on first line (op param currently not used) */
	 if ( IsMOSSDirectiveFirstLine(filename,&op) == True ) {

	      /* Call procedure to enhance msg */
	      if ( PerformMOSSOperation(scrn,MOSS_NOSEND) == -1 ) {
		   /* error encountered, return without sending */
		   return;
	      }
	      
	 }
	  
	 MsgSend(scrn->msg);
	 MsgSetReapable(scrn->msg);

    }


}

    

void XmhMOSSMenu(w, event, params, num_params)
    Widget      w;
    XEvent      *event;
    String      *params;
    Cardinal    *num_params;
{
    Scrn scrn = ScrnFromWidget(w);
    /* placeholder */
}


/* Save any changes to the message.  This also makes this message permanent. */

/*ARGSUSED*/
void XmhSave(w, event, params, num_params)
    Widget	w;
    XEvent	*event;
    String	*params;
    Cardinal	*num_params;
{
    Scrn scrn = ScrnFromWidget(w);
    DEBUG("XmhSave\n")
    if (scrn->msg == NULL) return;
    MsgSetPermanent(scrn->msg);
    if (MsgSaveChanges(scrn->msg))
	MsgClearReapable(scrn->msg);
}


/* Utility routine; creates a composition screen containing a forward message
   of the messages in the given msglist. */

CreateForward(mlist)
  MsgList mlist;
{
    Scrn scrn;
    Msg msg;
    scrn = NewCompScrn();
    msg = TocMakeNewMsg(DraftsFolder);
    MsgLoadForward(scrn, msg, mlist);
    MsgSetTemporary(msg);
    MsgSetScrnForComp(msg, scrn);
    MapScrn(scrn);
}

int ChkMOSSLogStat ()
{
    if (system(MOSS_LOG_CHECK) == 0) {
      return(OK);
    } else {
      return(MakeSureLoginOrQuit());
    }
}

int MakeSureLoginOrQuit ()
{
   PopupNotice(MOSS_LOG_NOTICE, FreeStatus, (Pointer) NULL);
   return(QUIT);
}


static void FreeStatus( w, closure, call_data )
    Widget w;                   /* unused */
    Pointer closure;
    Pointer call_data;          /* unused */
{
    CommandStatus status = (CommandStatus)closure;
    if (status->popup != (Widget)NULL) {
        XtPopdown( status->popup );
        XtDestroyWidget( status->popup );
    }
    if (status->error_buffer != NULL) XtFree(status->error_buffer);
    XtFree( closure );
}

