#!/bin/sh

status=1
tmpfile1="/usr/tmp/signpt$$.1"
tmpfile2="/usr/tmp/signpt$$.2"

trap '/bin/rm -f $tmpfile1 $tmpfile2; exit $status' 0 1 2 3 9 15

umask 177

if [ $# -ne 0 ]; then 
   echo "$0 takes text from standard input, converts it to a MIME object," 1>&2
   echo "signs it, and places the resulting MOSS object on standard output." 1>&2
   echo " " 1>&2
   echo "Usage: $0" 1>&2
   echo " " 1>&2
   exit 
fi

echo 'Content-Type: text/plain; charset="us-ascii"'  > $tmpfile1
echo '' >> $tmpfile1
cat >> $tmpfile1

signobj.sh $tmpfile1 $tmpfile2
status=$?

if [ $status -ne 0 ]; then
   echo "$0: Bad return from signobj.sh ($status)." 1>&2
elif [ ! -s $tmpfile2 ]; then
   echo "$0: signobj.sh did not produce a signed message." 1>&2
   status=1
fi

cat $tmpfile2

exit





