#!/bin/sh

status=1
tmpfile1="/tmp/encobj1.$$"
tmpfile2="/tmp/encobj2.$$"

trap '/bin/rm -f $tmpfile1 $tmpfile2; exit $status' 0 1 2 3 9 15

umask 177

boundary="--$$`date | tr '[a-zA-Z0-9 :]' '[0-909a-za-z]'`e--"

trap '/bin/rm -f $tmpfile1 $tmpfile2' 0 1 2 3 9 15

if [ $# -lt 3 ]; then 
   echo "$0 encrypts a MIME object and produces a new MOSS object." 1>&2
   echo " " 1>&2
   echo "Usage: $0 <input object file> <output object file> <alias> alias [...]" 1>&2
   echo " " 1>&2
   exit
fi
   
if [ ! -r "$1" ]; then 
   echo "$0: Unable to read input file $1." 1>&2
   exit
fi

echo 'Content-Type: multipart/encrypted; protocol="application/moss-keys";'> $2
echo '        boundary="'$boundary'"' >> $2
echo '' >> $2
echo "--$boundary" >> $2
echo "Content-Type: application/moss-keys" >> $2
echo "Content-Transfer-Encoding: quoted-printable" >> $2
echo '' >> $2

encrypt data-in $1 header-out $tmpfile1 data-out $tmpfile2  $*
status=$?

if [ $status -ne 0 ]; then
   echo "$0: encrypt returned a non-zero return code ($status)." 1>&2
   /bin/rm -f $2
   exit
fi

mossencode -qp < $tmpfile1 >> $2

echo '' >> $2
echo "--$boundary" >> $2
echo "Content-Type: application/octet-stream" >> $2
echo "Content-Transfer-Encoding: base64" >> $2
echo '' >> $2

mossencode -b64 < $tmpfile2 >> $2

echo '' >> $2
echo "--$boundary--" >> $2

exit







