#!/bin/sh

if [ $# -ne 0 ]; then 
   echo " " 1>&2
   echo "$0 takes an encoded MIME body part on standard input and" 1>&2
   echo "writes the decoded output to standard output.  Input must be" 1>&2
   echo "from a pipe, not a file redirect!  Use cat as a front end if" 1>&2
   echo "necessary." 1>&2
   echo " " 1>&2
   echo "Usage: $0"
   echo " " 1>&2
   exit 1
fi

line=' '
cte=''
until [ "$line" = "" ]; do
   read line
   if [ -z "$cte" ]; then
      cte=`echo "$line" | tr 'A-Z' 'a-z' | \
      sed -n 's/^content-transfer-encoding: *\(.*\)$/\1/p'`
   fi
done

if [ "$cte" = '' ]; then
   cat
elif [ "$cte" = 'quoted-printable' ]; then
   mossdecode -qp
   status=$?
   if [ $status -ne 0 ]; then
      echo "$0: mossdecode -qp returned a non-zero status ($status)." 1>&2
   fi
elif [ "$cte" = 'base64' ]; then
   mossdecode -b64
   status=$?
   if [ $status -ne 0 ]; then
      echo "$0: mossdecode -b64 returned a non-zero status ($status)." 1>&2
   fi
else
   echo "$0: Unknown Content-Transfer-Encoding \"$cte\"." 1>&2
   status=1
fi

exit $status
