#!/bin/sh

# James Galvin <galvin@tis.com>					4/94
# 
# This script expects to be invoked from a MIME user agent with arguments
# corresponding to data to be encrypted with MOSS.  A common configuration is
# for a MIME user agent to collect the data to be encrypted in a file and
# invoke this script with that file.
# 
# When using the Rand MH Version 6.8.3, the following addition to the user's
# .mh_profile file is recommended:
# 
# 	mhn-compose-application/moss-keys: mossencrypt.sh %s %f %a

# Exactly 3 arguments are required, in the order indicated, as follows:
# 
# 	type		-- the MIME content type of the data to be encrypted
# 	subtype		-- the MIME sub-content type; this information is
#			   currently unused
# 	data		-- the file with the data to be encrypted
# 
# In addition, at least one of the following arguments is required:
# 
# 	recip=ALIAS	-- indicate MOSS recipient of message; as many as are
#			   needed may be specified


status=99
trap 'rm -f /tmp/e$$; exit $status' 0 1 2 3 9 15


umask 077


# a helpful message is printed and then we exit; exit code argument required

usage() {
	echo Usage: $0 type subtype data recip=alias \[ recip=alias ... \] 1>&2
	status=$1
	exit
}


if [ $# -lt 4 ]; then
	usage 2
fi

TYPE=$1
STYP=$2
DATA=$3

shift ; shift ; shift

if [ ! -f $DATA ]; then
	echo $0: $DATA: not a file 1>&2
	usage 3
fi
if [ ! -r $DATA ]; then
	echo $0: $DATA: unable to open for reading 1>&2
	usage 4
fi

RECIPS=
ORIG=

while [ $# -ge 1 ]; do
	case $1 in
	orig=*)
		ORIG="sig-alias `echo $1 | sed -n 's/orig=\(.*\)/\1/p'`"
		;;

	recip=*)
		RECIPS="$RECIPS alias `echo $1 | sed -n 's/recip=\(.*\)/\1/p'`"
		;;

	protocol=application/moss-keys)
		;;
	boundary=*)
		;;

	*)
		echo $0: unknown option \"$1\" 1>&2
		usage 1
		;;
	esac
	shift
done

if [ -z "$RECIPS" ]; then
	echo $0: must specify at least one \"recip=\" 1>&2
	usage 5
fi

if [ -t 0 -a -r /dev/tty -a -w /dev/tty ]; then
	encrypt data-in $DATA data-out /tmp/e$$ $RECIPS $ORIG 1>/dev/tty
	status=$?
else
	cat $DATA | encrypt $RECIPS $ORIG > /tmp/e$$
	status=$?
fi

if [ $status -ne 0 ]; then
	exit
fi

cat /tmp/e$$

status=0
exit
