/*
Copyright (C) 1992,1993,1994,1995 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/MOSS source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/



#ifndef	_CRL_
#define _CRL_

#include "algid.h"
#include "bbuf.h"

struct rcl_entry {
	struct bbuf *serial;	/* cert serial number */
	long date;		/* revocation date UTC Time */
	struct rcl_entry *prev; /* previous entry */
	struct rcl_entry *next; /* next entry */
};

struct crltobesigned {
	struct algid *sig_alg;	/* signature algorithm */
	struct bbuf *issuer;	/* issuer name */
	struct rcl_entry *rcl;	/* list of cert serial numbers and dates */
	long lastupdate;	/* UTC Time */
	long nextupdate;	/* UTC Time */
};

struct crl {
      struct crltobesigned *tobesigned;	/* certificate */
      struct algid *sig_alg;      	/* signature algorithm */
      struct bbuf *sig;           	/* signature */
      int status;			/* status of this CRL */
};

#define NULL_CRL		(struct crl *)0
#define NULL_CRLTOBESIGNED	(struct crltobesigned *)0
#define NULL_RCL_ENTRY		(struct rcl_entry *)0

#define FREE_CRL(x)     	if ((x) != NULL_CRL) { \
				    (void) free_crl(x); \
				    (x) = NULL_CRL; \
				} \
				else

#define FREE_CRLTOBESIGNED(x)	if ((x) != NULL_CRLTOBESIGNED) { \
				     (void) free_crltobesigned(x); \
				     (x) = NULL_CRLTOBESIGNED; \
				} \
				else

#define FREE_RCL(x)     	if ((x) != NULL_RCL_ENTRY) { \
				     (void) free_rcl(x); \
				     (x) = NULL_RCL_ENTRY; \
				} \
				else

extern struct crl		*dup_crl();
extern struct crltobesigned	*alloc_crltobesigned(), *dup_crltobesigned();
extern struct rcl_entry		*alloc_rcl_entry(), *dup_rcl(),
				*dup_rcl_entry();
extern struct rcl_entry		*_rclfirst(), *_rclnext(), *_rcllast(), 
				*_rclcurrent();

#endif	/* not _CRL_ */

