/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 * 
 * Changes by Angelos D. Keromytis and Niels Provos
 * ported from OpenBSD 2.2 by Petr Novak, <pn@i.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

/*
 * Declarations relevant to encapsulation-like operations.
 */

struct sockaddr_encap
{
	__u8	sen_len;		/* length */
	__u8	sen_family;		/* AF_ENCAP */
	__u16	sen_type;		/* see SENT_* */
	union
	{
		__u8	Data[16];

		struct			/* SENT_IP4 */
		{
			struct in_addr Src;
			struct in_addr Dst;
			__u16 Sport;
			__u16 Dport;
			__u8 Proto;
			__u8 Filler[3];
		} Sip4;

		struct
		{
			struct in_addr Dst;
			__u32 Spi;
			__u8 Sproto;
			__u8 Filler[7];
		} Sipsp;
	} Sen;
};

#define sen_data	Sen.Data
#define sen_ip_src	Sen.Sip4.Src
#define sen_ip_dst	Sen.Sip4.Dst
#define sen_proto	Sen.Sip4.Proto
#define sen_sport	Sen.Sip4.Sport
#define sen_dport	Sen.Sip4.Dport
#define sen_ipsp_dst	Sen.Sipsp.Dst
#define sen_ipsp_spi	Sen.Sipsp.Spi
#define sen_ipsp_sproto	Sen.Sipsp.Sproto

/*
 * The "type" is really part of the address as far as the routing
 * system is concerned. By using only one bit in the type field
 * for each type, we sort-of make sure that different types of
 * encapsulation addresses won't be matched against the wrong type.
 * 
 */

#define SENT_IP4	0x0001		/* data is two struct in_addr */
#define	SENT_IPSP	0x0002		/* data as in IP4 plus SPI */

#define SEN_HDRLEN	(2*sizeof(__u8)+sizeof(__u16))

#define SEN_IP4_SRCOFF	(0)
#define SEN_IP4_DSTOFF (sizeof (struct in_addr))
#define SEN_IP4_OPTOFF	(2 * sizeof (struct in_addr))

#define SEN_IP4_LEN	(SENT_HDRLEN + SENT_IP4_OPTOFF)

#define	AF_ENCAP	13

/*
 * An entry in the radix tree 
 */

struct rjtentry
{
	struct	radij_node rd_nodes[2];	/* tree glue, and other values */
#define	rd_key(r)	((struct sockaddr_encap *)((r)->rd_nodes->rj_key))
#define	rd_mask(r)	((struct sockaddr_encap *)((r)->rd_nodes->rj_mask))
	short	rd_flags;
	short	rd_count;
};

/*
 * An encapsulation route consists of a pointer to a 
 * radix tree entry and a SAID (a destination address/SPI pair).
 */

struct eroute
{
	struct rjtentry er_rjt;
	struct sockaddr_encap er_dst;
	struct sockaddr_encap er_eaddr;
	struct sockaddr_encap er_emask;
};

#ifdef DEBUG_IPSEC_EROUTE

extern int debug_eroute;

#define DB_ER_PROCFS	0x0001

#endif

#ifdef DEBUG_IPSEC_SPI

extern int debug_spi;

#define DB_SP_PROCFS	0x0001

#endif

