(define (passphrase:handle-form)
  (let ((old-pp  (ui:form-datum "new-passphrase"))
	(new-pp1 (ui:form-datum "old-passphrase"))
	(new-pp2 (ui:form-datum "new-passphrase-rep")))
    (when (and old-pp new-pp1 new-pp2)
      (list
       "<h1>Attempting to change your passphrase</h1>"
       (cond ((not (equal? new-pp1 new-pp2))
	      (format nil "<b>The two copies of your new passphrase were not the same.~&~
                              The old passphrase was not checked, and your passphrase was not changed.</b>"))
	     (t
	      (passphrase:set-passphrase old-pp new-pp1 #t)))))) ; Save immediately.
  "")

(define (passphrase:passphrase-secure? passphrase)
  #t)					; %%% should check security of the passphrase here

(define (passphrase:set-passphrase old-pass new-pass save-immediately)
  (cond ((not *hashed-passphrase*)
	 (passphrase:set-passphrase-unconditionally new-pass save-immediately)
	 "<b>Your passphrase has been set.</b>")
	((equal? *hashed-passphrase* 
;		     (ssl:sha1-hash	; %%% This tries to establish a salt, but we'd neede *l-y-pub-key* first...
;		      (string-append *local-yenta-pub-key* old-pass))
		     (ssl:sha1-hash old-pass) ; %%% Saltless attempt.
		     )
	 (cond ((passphrase:passphrase-secure? new-pass)
		(passphrase:set-passphrase-unconditionally new-pass save-immediately)
		"<b>Your passphrase has been changed.</b>")
	       (t
		"<b>Your new passphrase is not sufficiently secure.  Please try another one.</b>")))
	(t
	 "<b>You gave your old passphrase incorrectly.  Your passphrase has not been changed.</b>")))

(define (passphrase:set-passphrase-unconditionally pass save-immediately)
  (set! *hashed-passphrase* (ssl:sha1-hash pass))
  (when save-immediately
    ;; Save immediately after changing the passphrase.  Otherwise, if we take a crash, the user
    ;; will think that the -new- passphrase is the one to use, but the data will be encrypted under
    ;; the old one, and he'll lose.  This is a parameter because the stuff that runs for a brand-new
    ;; Yenta, and when attempting a trial decryption during two-phase startup (e.g., after asking for
    ;; the passphrase) does -not- want to save immediately!  But we want to force everybody who might
    ;; want to change the passphrase to think about the question of whether to save, so we force the
    ;; issue by making it a required parameter here.
    (vars:save-encrypted)))
