(yreq "Utilities/yenta-utils")

(define (news:update-news)
  (set! *ui:news-new* #f)
  (when (and (ui:from-form?)
	     (equal? (number->string *ui:news-seq-num*)
		     (ui:form-datum "seq-num")))
    (set! *ui:news* (ui:remove-checked *ui:news*)))
  "")

(define (news:collapse news)
  (define (joiner s)
    (join-strings s ""))
  (join-strings (map joiner news) "\n"))

(define (news:update-news-with-section)
  (let ((news (news:show-news)))
    (cond ((equal? news "")
	   "<b>No news since you last checked.</b>")
	  (t
	   (format nil "<h1>Things I've done lately</h1>~&~
                        Check the box beside each item when you've read it and I'll know not to keep it.<p>~&~
                        <form action = \"news.html\" method = \"post\">~&~
                        <input type = \"hidden\" name = \"seq-num\" value = \"~A\">~&~
                        <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">~A</table><p>~&~
                        <input type = \"submit\" value = \"Erase checked items\">~&~
                        </form>~&"
		   (news:new-seq-num)
		   news)))))

(define (news:new-seq-num)
  (inc! *ui:news-seq-num*)
  *ui:news-seq-num*)

(define (news:show-news)
  (let ((item-num -1)
	(results '()))
    (map (lambda (rec)
	   (inc! item-num)
	   (push! (format nil "<tr>~&~
                                 <td>~&~
                                   <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\">~&~
                                      <tr>~&~
                                        <td><input type = \"checkbox\" name = \"item-~A\"></td>~&~
                                        <td>&nbsp;<a href = \"~A\">~A:~A~A~A</a></td>~&~
                                      </tr>~&~
                                      <tr>~&~
                                        <td>&nbsp;</td>~&~
                                        <td><b>~A</b></td>~&~
                                      </tr>~&~
                                   </table>~&~
                                 </td>~&~
                               </tr>"
			  item-num
			  (nth 0 rec)
			  (nth 1 rec)
			  (nth 2 rec) (nth 3 rec) (nth 4 rec) ; Yuck!  This gets "[", a date, and "]".
			  (join-strings (nthcdr 5 rec) ""))
		  results))
	 *ui:news*)
    (join-strings (reverse results) "\n")))
