(yreq "Affordances/attestations-filter")
(yreq "UI/scheme-to-html")
(yreq "Utilities/yenta-utils")

;;; %%% At some point, I -really- should implement a handle -> YID
;;; %%% lookup table so users can specify the handle of the Yenta to block.
;;; %%% After all, we -must- know it already if the user wants to block it.

(define (af:check-blocked-yentas)
  (let ((datum (ui:form-datum "block")))
  (cond (datum
	 (let ((yid (and (hex-string? datum) ; If it ain't a hex string, ...
			 (ui:hex-or-base64->bytes datum)))) ; ... this will blow out, so be careful.
	   (cond (yid
		  (af:block! yid)
		  (format nil "<h3>I have just blocked <i>~A</i>.</h3>" yid))
		 (t
		  (let* ((yids (identity:reverse-lookup datum #t)) ; Case-insensitive.  This screws the user if he knows "Foo" and "foo'; fix later.
			 (n (length yids)))
		    (cond ((zero? n)
			   (format nil "<b><i>~A</i> doesn't look like a Yenta-ID, and I don't know a Yenta with that handle, either.</b>" datum))
			  ((= n 1)
			   (format nil "<h3>I have just blocked <i>~A</i>.</h3>" datum)) ; Use the handle, not the YID:  that's what the user typed.
			  (t		; n > 1, so "are" and the plural below is correct and unconditional.
			   (format nil "<b>There are ~A known Yentas with the handle <i>~A</i>;~&~
                                           please specify a Yenta-ID instead.</b>" n datum))))))))
	(t
	 ""))))

(define (af:update-blocked-yentas)
  (set! *af:block-new* #f)
  (unless (ui:form-datum "block")	; %%% I don't understand why we check this.  --- Foner.
    (set! *yenta-block* (ui:remove-checked *yenta-block*))))

(define (af:new-seq-num)
  (inc! *af:block-seq-num*)
  *af:block-seq-num*)

(define (af:show-blocked-yentas)
  (let ((item-num -1)
	(results '()))
    (map (lambda (rec)
	   (inc! item-num)
	   (push! (format nil "<li><input type = \"checkbox\" name = \"item-~A\">&nbsp;~A"
			  item-num rec)
		  results))
	 *yenta-block*)
    results))

(define (af:show-currently-blocked)
  (af:update-blocked-yentas)
  (let ((blocked (af:show-blocked-yentas)))
    (cond ((null? blocked)
	   "<b>[No Yentas are currently blocked.]</b><p>")
	  (t
	   (format nil "<h1>Currently blocked Yentas</h1>~2&~
                        Check the box beside the blocked Yenta and I'll know to accept messages from that Yenta again.<p>~&~
                        <form action = \"block-user.html\" method = \"post\">
                          <input type = \"hidden\" name = \"seq-num\" value = \"~A\">
                          <ul>
                            ~A~&
                          </ul>
                          <input type = \"submit\" value = \"Unblock checked Yentas\">
                        </form><p>"
		   (af:new-seq-num)
		   (join-strings blocked "\n"))))))

;;; End of file.
