;; -*- Scheme -*-
;;
;; $Id: stringt19.scm,v 1.1 1998/03/16 08:00:10 foner Exp $

(require 'string:test:equal)
(require 'substring:replicate!)

(define substring:test:replicate!
  (lambda args
    (define a (lambda () (make-string 10 #\a)))
    (define b "*|")

    (if (not (null? args)) (display "Testing substring:replicate! ... "))

    (let ((s (a)))
      (substring:replicate! s 2 7 b 0 1)
      (string:test:equal 'substring:test:replicate!-a s "aa*****aaa"))

    (let ((s (a)))
      (substring:replicate! s 2 7 b 1 2)
      (string:test:equal 'substring:test:replicate!-b s "aa|||||aaa"))

    (let ((s (a)))
      (substring:replicate! s 2 7 b 0 2)
      (string:test:equal 'substring:test:replicate!-c s "aa*|*|*aaa"))

    (if (not (null? args)) (begin (display "done") (newline)))

    ))

;; eof
