; -*- Scheme -*-
;
; $Id: string53.scm,v 1.1 1998/03/16 08:00:00 foner Exp $

;------------

(require 'char-set?)
(require 'string:split-by-whitespace)
(require 'string:split-by-char-no-dups)
(require 'string:split-by-chars-no-dups)
(require 'string:split-by-string)
(require 'substring:find-by-knuth-morris-pratt)

;------------

;+doc
; procedure: string:split
; arguments: string chars
; signature: string x char-set -> string
; arguments: string char
; signature: string x char -> string
; arguments: string string
; signature: string x string -> string
; arguments: string
; signature: string -> string
;
; Splits STRING into a list of substrings using one of a variety of
; methods :-
;
;  * a char-set to define all the characters to be split on
;  * a single character defining the character to be split on
;  * a string defining the pattern to split on.
;  * whitespace if no method of trimming is supplied.
;
; Examples :-
;
; > (string:split "/usr/local/bin:/usr/bin:/usr/ucb/bin" #\:)
; ("/usr/local/bin" "/usr/bin" "/usr/ucb/bin")
;
; > (string:split "/usr/local/bin" #\/)
; ("usr" "local" "bin")
;
; > (string:split " usr local bin")
; ("usr" "local" "bin")
;
; If you'd prefer ("" "usr" "local" "bin") as the result of the above,
; then consider calling one of the more specialised SPLIT functions
; which will given this behaviour.
;
; > (string:split "    ")
; ()
;-doc

(define string:split
  (lambda (s . opt)
    (if (null? opt)
	(string:split-by-whitespace s)
	(let ((m (car opt)))
	  (cond
	   ((char? m)
	    (string:split-by-char-no-dups s m))
	   ((string? m)
	    ((string:split-by-string substring:find-by-knuth-morris-pratt m) s))
	   ((char-set? m)
	    (string:split-by-chars-no-dups s m))
	   (else (error 'string:split "invalid split option")))))))

; The choice of using Knuth-Morris-Pratt for splitting strings is arbitrary.
; Perhaps a simpler method would be better on average?

; eof
