; -*- Scheme -*-
;
; $Id: string13.scm,v 1.1 1998/03/16 07:59:37 foner Exp $

;+doc
; procedure: substring:upcase!
; arguments: string start end
; signature: string x int x int -> unspecified
; pre:       (<= 0 start end (string-length string))
;
; Modifies STRING such that every case-modifiable character betweeen
; START and END is coverted to upper case.
;
; Some examples.  In each of the following, assume that "a" is
; initially defined to be "occlUDed cASEmenTs"
;
; > (substring:upcase! a 0 18)
; > a
; "OCCLUDED CASEMENTS"
;
; > (substring:upcase! a 5 18)
; > a
; "occlUDED CASEMENTS"
;
; > (substring:upcase! a 5 15)
; > a
; "occlUDED CASEMEnTs"
;-doc

(define substring:upcase!
  (lambda (s ss se)
    (let loop ((i ss))
      (if (= i se)
	  i				; arbitrary return value
	  (begin
	    (string-set! s i (char-upcase (string-ref s i)))
	    (loop (+ i 1)))))))

;-------------

;+doc
; procedure: string:upcase!
; arguments: string 
; signature: string -> unspecified
;
; Modifies STRING such that every case-modifiable character
; is converted to upper case.
;
; Some examples.  In the following, assume that "a" is
; initially defined to be "occlUDed cASEmenTs"
;
; > (substring:upcase! a)
; > a
; "OCCLUDED CASEMENTS"
;-doc

(define string:upcase! (lambda (s) (substring:upcase! s 0 (string-length s))))

; eof
