; -*- Scheme -*-
;
; $Id: pathname09.scm,v 1.1 1998/03/16 07:59:08 foner Exp $
;
;------------

(require 'pathname:name)
(require 'pathname:type)

;------------

;+doc
; procedure: unix:pathname->file-string
; arguments: pathname
; signature: pathname -> string
;
; Returns the filename, type and version of the PATHNAME.
; Equivalent to the CommonLisp function FILE-NAMESTRING
;-doc

(define unix:pathname->file-string
  (lambda (p)
    (let ((r ""))
      (let ((n (pathname:name p)))
	(if n (set! r n)))
      (let ((t (pathname:type p)))
	(if t (set! r (string-append r (string-append "." t)))))
      r)))

; The ugly side-effecting code is to avoid calling STRING-APPEND when
; it is known that the string is "".  Probably isn't worth the ugly
; code though!

; eof
