;; -*- Scheme -*-
;;
;; $Id: avl-tree06.scm,v 1.1 1998/03/16 07:57:17 foner Exp $

;;------------

(require 'avl-tree::left)
(require 'avl-tree::data)
(require 'avl-tree::right)
(require 'avl-tree:nil?)

;;------------

;;+doc
;; procedure: avl-tree:find
;; arguments: tree key unwrap-key <? if-found if-not-found
;; signature: forall a, b, c, d =>
;;  avl-tree[a,b,c] x a x (c -> a) x (a x a -> bool) x (c -> d) x (() -> d) -> d
;;
;; Look for an element with the given KEY in TREE.  If a matching
;; element is found IF-FOUND is called with the element.  If no
;; matching element is found, IF-NOT-FOUND is called with no arguments.
;;-doc

(define avl-tree:find
  (lambda (t k uk <? if-found if-not-found)
    (let loop ((t t))
      (if (avl-tree:nil? t)
	  (if-not-found)
	  (let ((ck (uk (avl-tree::data t))))
	    (cond ((<? k ck) (loop (avl-tree::left t)))
		  ((<? ck k) (loop (avl-tree::right t)))
		  (else (if-found (avl-tree::data t)))))))))

;; eof
