#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <savant.h>
#include <savutil.h>
#include <template.h>
#include <savantio.h>
#include <main.h>

void instructions(void);

int SavantVerbose = 0, SavantDebug = 0;

FILE *TITLE_FILE=NULL, *TOFF_FILE=NULL;
FILE *DOCLOC_FILE=NULL, *DLOFF_FILE=NULL;
FILE *WMAP_FILE=NULL, *LOG_FILE=NULL;
FILE *BIAS_FILE=NULL;

void instructions(void)  
{
  fprintf(stderr,"\nusage:\n");
  fprintf(stderr,"  ra-index [-v] [-d] [-c <config-file>] <base-dir> <sources> [-e <excludees>] \n");
  fprintf(stderr,"  -v invokes savant indexing verbosely;  -d provides debugging messages. \n");
  fflush(stderr);
}

#if !defined(PATH_MAX)
#define PATH_MAX 1024
#endif

List_of_Files *init_file_list(char *sources[],
			      char *excludees[])
{
  int i;
  List_of_Files *files, *tail;
  char cwd[PATH_MAX+2], *cur_dir, *temp_excl;

  files = tail = NULL;
#ifdef HAVE_GETCWD
  getcwd(cwd, PATH_MAX);
#else
  getwd(cwd);
#endif
  strcat(cwd, "/");

  /* expand excludee pathnames */
  for(i=0; excludees[i] != NULL; i++) {
    if(excludees[i][0] != '/') {
      temp_excl = excludees[i];
      excludees[i] = (char *)malloc(strlen(temp_excl) + strlen(cwd) + 2);
      strcpy(excludees[i], cwd);
      strcat(excludees[i], temp_excl);
    }
    if (excludees[i][strlen(excludees[i])-1] == '/') {
      excludees[i][strlen(excludees[i])-1] = '\0';
    }
  }

  /* assign each expanded pathname to cur_dir and find some files */
  for(i=0; sources[i] != NULL; i++) {
    if(sources[i][0] == '/') {
      cur_dir = sources[i];
    }
    else {
      cur_dir = (char *)malloc(strlen(sources[i]) + strlen(cwd) + 2);
      strcpy(cur_dir, cwd);
      strcat(cur_dir, sources[i]);
    }
    if (sources[i][strlen(sources[i])-1] == '/') {
      sources[i][strlen(sources[i])-1] = '\0';
    }
    if(i==0) {
      files = tail = find_files(cur_dir, excludees);
    }
    else {
      if (tail != NULL) {
	while(tail->next != NULL) {
	  tail = tail->next;
	}
	tail->next = find_files(cur_dir, excludees);
      }
      else {
	files = tail = find_files(cur_dir, excludees);
      }
    }
    if(cur_dir != sources[i]) {
      free(cur_dir);
    }
  }

  return(files);
}

void main(int argc,
	  char *argv[])
{
  int i, j, sources_done=0;
  char *config_name=NULL, *sources[512], *excludees[512], *db_name=NULL,
    db_dir[PATH_MAX+2];
  

  for (i=0; i<512; i++) 
    sources[i] = excludees[i] = NULL;
  
  j = 0;
  for (i=1; i < argc; i++)
    if (argv[i][0] == '-') 
      switch (argv[i][1]) {
      case 'c':
	if (config_name == NULL) {
	  config_name = argv[++i];
	}
	else {
	  instructions();
	  exit(-1);
	}
	break;
      case 'v':
	SavantVerbose = 1;
	break;
      case 'd':
	SavantDebug = 1;
	break;
      case 'e':
	if(sources_done == 0) {
	  sources_done = 1;
	  j = 0;
	}
	else {
	  instructions();
	  exit(-1);
	}
	break;
      default:
	instructions();
	exit(-1);
      }
    else if(db_name == NULL) { /* do the database name */
      db_name = argv[i];
    } 
    else {  /* do sources and excludees */
      if (sources_done == 0) {
	sources[j++] = argv[i];
      }
      else {
	excludees[j++] = argv[i];
      }
    }

  if(SavantVerbose || SavantDebug) {
    puts(VERSION);
  }

  if (db_name == NULL) {
    instructions();
    exit(-1);
  }

  if(db_name[0] != '/') {  
    /* if not absolute pathname, tack it onto cwd */
    /* (is there a better way to do this?) */
#ifdef HAVE_GETCWD
    getcwd(db_dir, PATH_MAX);
#else
    getwd(db_dir);
#endif
    strcat(db_dir, "/");
    strncat(db_dir, db_name, PATH_MAX + 1 - strlen(db_dir));
  }
  else { /* use the absolute pathname */
    strncpy(db_dir, db_name, PATH_MAX + 2);    
  }
  db_dir[PATH_MAX+1] = '\0';

  load_config(config_name);
  core_comm_local();

  TITLE_FILE = open_or_die(db_dir, TITLE_FNAME, "w");
  TOFF_FILE = open_or_die(db_dir, TOFF_FNAME, "w");
  DOCLOC_FILE = open_or_die(db_dir, DOCLOC_FNAME, "w");
  DLOFF_FILE = open_or_die(db_dir, DLOFF_FNAME, "w");
  BIAS_FILE = open_or_die(db_dir, BIAS_FNAME, "w");
  WMAP_FILE = open_or_die(db_dir, WMAP_FNAME, "w");
  LOG_FILE = open_or_die(db_dir, "log", "w");
  init_write(db_dir);
  savant_index(init_file_list(sources, excludees));

  exit(0);

}
