#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>

/************************/
/* listener definitions */
/************************/

#define MAKLSNR(fd) cons(tc16_tcplsnr, fd);

#define LSNRP(obj) (NIMP(obj) && (TYP16(obj) == tc16_tcplsnr))

#define LSNRFD(obj) (CDR(obj))

int tc16_tcplsnr;

/*******************/
/* tcp definitions */
/*******************/

#define MAKTCP(fd, info) cons(tc16_tcp | RDNG | WRTNG | OPN, \
			      maktcp(fd, &info));
#define ITCPP(obj) (NIMP(obj) && (TYP16(obj) == tc16_tcp))
int tc16_tcp;

/* tcp object structure */

typedef struct
{
  char *overflow; /* writing overflow buffer */
  unsigned char *buf; /* reading buffer */
  struct sockaddr_in info;
  int fd;
  unsigned overstart, overnum; /* next char to write, next empty spot */
  unsigned oversz; /* ammount of memory currently allocated for overflow */
  unsigned bufpos, bufmax; /* next char to read, last char prefetched */
  unsigned long charssent, charsread; /* meters of characters transfered */
  char state;
  int err; /* for state 6, the error code */
} tcpobj;

extern unsigned long totalsent, totalread;
/* All characters transfered by TCP via this package. Note that this will wrap
 * around after 4G of data has been transfered; be careful that your code
 * doesn't rely on monotonicity if it could run for a very long time. */

/* states: 0: connection pending
 *	   1: open both ways
 *	   2: trying to close output
 *	   3: input only
 *	   4: trying to close, or closed.
 *	   5: was refused (asynchronous)
 * (fd == 0): closed */

SCM p_rdcount(SCM);
