/* mink.c: slight modification by itojun@csl.sony.co.jp.
 * original file can be found in termkey.zip.
 *
 * termkey.zip version by Neil Haller.
 * original by Phil Karn.
 */
/*  Hot key TSR stand-alone program for computing responses to S/KEY
 *  challenges.  Takes the iteration count, seed, and password as arguments.
 *  Produces six word s/key one-time password response.
 *
 *  This module is adapted from Phil Karn's main program.  The changes are
 *  limited to changing a main program to a function and the way the
 *  output is handled.  This version is MSDOS only; the flexibility to
 *  compile on UNIX has been lost.
 *
 *  Usage example:
 *	mink(88, "ka9q2", "password", &result);
 *  Output (stuffed to result buffer):
 *	OMEN US HORN OMIT BACK AHOY
 *
 */
#include "mink.h"

int	mink(n, seed, passwd, result)
	int	n;
	char	*seed;
	char	*passwd;
	char	*result;
{
	static char	key[8];

	/*  Crunch seed and password into starting key */
	if(keycrunch(key, seed, passwd) != 0)
	{
		return -1;
	}

	while (n-- != 0)
	{
		f(key);
	}

	strcpy(result, btoe(key));	//  Get the six little words
	return 0;
}
