/* accessfile.c: Handle trusted network access file and per-user overrides.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Modified at NRL for OPIE 2.0.
	Written at Bellcore for the S/Key Version 1 software distribution
		(login.c).
*/
#include "opie_cfg.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef ACCESS_FILE

/* Turn host into an IP address and then look it up in the authorization
 * database to determine if ordinary password logins are OK
 */
int opieaccessfile(host)
char *host;
{
  long n;
  struct hostent *hp;
  FILE *fp;
  char buf[128], **lp;

#ifdef DEBUG
  fprintf(stderr, "accessfile: host=%s\n", host);
#endif	/* DEBUG */
  if (!host[0])
    /* Local login, okay */
    return (1);
  if (isaddr(host)) {
    n = inet_addr(host);
    return rdnets(n);
  } else {
    hp = gethostbyname(host);
    if (hp == NULL) {
      printf("Unknown host %s\n", host);
      return 0;
    }
    for (lp = hp->h_addr_list; *lp != NULL; lp++) {
      memcpy((char *) &n, *lp, sizeof(n));
      if (rdnets(n))
	return (1);
    }
    return (0);
  }
}

int rdnets(host)
long host;
{
  FILE *fp;
  char buf[128], *cp;
  long pattern, mask;
  int permit_it;

  fp = fopen(ACCESS_FILE, "r");
  if (fp == NULL)
    return 0;
  while (fgets(buf, sizeof(buf), fp), !feof(fp)) {
    if (buf[0] == '#')
      continue;	/* Comment */
    cp = strtok(buf, " \t");
    if (cp == NULL)
      continue;
    /* two choices permit of deny */
    if (strncasecmp(cp, "permit", 4) == 0) {
      permit_it = 1;
    } else {
      if (strncasecmp(cp, "deny", 4) == 0) {
	permit_it = 0;
      } else {
	continue;	/* ignore; it is not permit/deny */
      }
    }
    cp = strtok(NULL, " \t");
    if (cp == NULL)
      continue;	/* Invalid line */
    pattern = inet_addr(cp);
    cp = strtok(NULL, " \t");
    if (cp == NULL)
      continue;	/* Invalid line */
    mask = inet_addr(cp);
#ifdef DEBUG
    fprintf(stderr, "accessfile: %08x & %08x == %08x (%s)\n", host, mask, pattern, ((host & mask) == pattern) ? "true" : "false");
#endif	/* DEBUG */
    if ((host & mask) == pattern) {
      fclose(fp);
      return permit_it;
    }
  }
  fclose(fp);
  return 0;
}


/* Return TRUE if string appears to be an IP address in dotted decimal;
 * return FALSE otherwise (i.e., if string is a domain name)
 */
int isaddr(s)
register char *s;
{
  char c;

  if (s == NULL)
    return 1;	/* Can't happen */
  while ((c = *s++) != '\0') {
    if (c != '[' && c != ']' && !isdigit(c) && c != '.')
      return 0;
  }
  return 1;
}

#else	/* ACCESS_FILE */
int opieaccessfile(host)
char *host;
{
  return !host[0];
}

#endif	/* ACCESS_FILE */

/* Returns the opposite of what you might expect */
/* Returns 1 on error (allow)... this might not be what you want */
int opiealways(homedir)
char *homedir;
{
  char *opiealwayspath;
  int i;

  if (!homedir)
    return 1;

  if (!(opiealwayspath = malloc(strlen(homedir) + sizeof(OPIE_ALWAYS_FILE) + 1)))
    return 1;

  strcpy(opiealwayspath, homedir);
  strcat(opiealwayspath, "/");
  strcat(opiealwayspath, OPIE_ALWAYS_FILE);
  i = access(opiealwayspath, F_OK);
  free(opiealwayspath);
  return (i);
};
