; -*- Scheme -*-
;
; $Id: string26.scm,v 1.1 1998/03/16 07:59:45 foner Exp $

;+doc
; procedure: substring:reverse!
; arguments: string start end
; signature: string x int x int -> unspecified
; pre:       (<= 0 start end (string-length string))
;
; Modifies STRING such that the characters between START (inclusive)
; and END (exclusive) are reversed.
;-doc

(define substring:reverse!
  (lambda (string start end)
    (let* ((l (- end start))
	   (m (+ start (quotient l 2))))
      (let loop ((i (- m 1)) (j (+ m (if (even? l) 0 1))))
	(if (negative? i)
	    i
	    (let ((t (string-ref string i)))
	      (string-set! string i (string-ref string j))
	      (string-set! string j t)
	      (loop (- i 1) (+ j 1))))))))

;------------

;+doc
; procedure: string:reverse!
; arguments: string
; signature: string -> unspecified
;
; Modifies STRING such that the characters are reversed.
;
;-doc

(define string:reverse!
  (lambda (string)
    (substring:reverse! string 0 (string-length string))))

; eof
