; -*- Scheme -*-
;
; $Id: pathname19.scm,v 1.1 1998/03/16 07:59:14 foner Exp $

(require 'unix:pathname:+directory-string)

;+doc
; procedure: pathname:+directory-string
; arguments: pathname directory
; signature: pathname x string -> pathname
;
; Creates a new pathname consisting of PATHNAME with the directory
; overriden with DIRECTORY.   Some examples where P->S == PATHNAME->STRING
; and S->P == STRING->PATHNAME :-
;
; > (p->s (pathname+directory-string (s->p "/tmp/pathname15.scm") "/usr/me"))
; "/usr/me/pathname.scm"
;
; > (p->s (pathname+directory-string (s->p "/tmp/pathname15.scm") "/usr/me/"))
; "/usr/me/pathname.scm"
;
; > (p->s (pathname+directory-string (s->p "/tmp/pathname15.scm") "../usr/me"))
; "../usr/me/pathname.scm"
;-doc

(define pathname:+directory-string unix:pathname:+directory-string)

; Defaults to UNIX style, replace this as necessary for your system.

; eof
